/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring;

import com.github.developframework.resource.AbstractResourceManager;
import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ResourceDefinition;
import com.github.developframework.resource.Search;
import com.github.developframework.resource.spring.SpringDataResourceHandler;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class SpringDataResourceManager<ENTITY extends Entity<ID>, ID extends Serializable, REPOSITORY extends PagingAndSortingRepository<ENTITY, ID>>
extends AbstractResourceManager<ENTITY, ID> {
    protected REPOSITORY repository;
    protected TransactionTemplate transactionTemplate;

    public SpringDataResourceManager(REPOSITORY repository, ResourceDefinition<ENTITY> resourceDefinition) {
        super(resourceDefinition);
        this.repository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ENTITY> add(Object dto) {
        if (this.resourceOperateRegistry.isUniqueEntity()) {
            SpringDataResourceManager springDataResourceManager = this;
            synchronized (springDataResourceManager) {
                return (Optional)this.transactionTemplate.execute(transactionStatus -> super.add(dto));
            }
        }
        return (Optional)this.transactionTemplate.execute(transactionStatus -> super.add(dto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ENTITY> modifyById(ID id, Object dto) {
        if (this.resourceOperateRegistry.isUniqueEntity()) {
            SpringDataResourceManager springDataResourceManager = this;
            synchronized (springDataResourceManager) {
                return (Optional)this.transactionTemplate.execute(transactionStatus -> super.modifyById(id, dto));
            }
        }
        return (Optional)this.transactionTemplate.execute(transactionStatus -> super.modifyById(id, dto));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ENTITY entity) {
        if (this.resourceOperateRegistry.isUniqueEntity()) {
            SpringDataResourceManager springDataResourceManager = this;
            synchronized (springDataResourceManager) {
                Boolean execute = (Boolean)this.transactionTemplate.execute(transactionStatus -> super.remove(entity));
                return execute != null ? execute : false;
            }
        }
        Boolean execute = (Boolean)this.transactionTemplate.execute(transactionStatus -> super.remove(entity));
        return execute != null ? execute : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ENTITY> removeById(ID id) {
        if (this.resourceOperateRegistry.isUniqueEntity()) {
            SpringDataResourceManager springDataResourceManager = this;
            synchronized (springDataResourceManager) {
                return (Optional)this.transactionTemplate.execute(transactionStatus -> super.removeById(id));
            }
        }
        return super.removeById(id);
    }

    public <SEARCH extends Search<ENTITY>> List<ENTITY> list(SEARCH search) {
        List list = this.resourceHandler.query(search);
        return (List)this.execSearchOperate(list);
    }

    public <SEARCH extends Search<ENTITY>> List<ENTITY> list(Sort sort, SEARCH search) {
        List list = ((SpringDataResourceHandler)this.resourceHandler).query(sort, search);
        return (List)this.execSearchOperate(list);
    }

    public <SEARCH extends Search<ENTITY>> Page<ENTITY> pager(Pageable pageable, SEARCH search) {
        Page page = ((SpringDataResourceHandler)this.resourceHandler).queryPager(pageable, search);
        return (Page)this.execSearchOperate((Iterable)page);
    }

    public REPOSITORY getRepository() {
        return this.repository;
    }
}

