/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring.cache;

import com.github.developframework.resource.Entity;
import com.github.developframework.resource.spring.cache.ResourceCacheOperate;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;

public class HashResourceCacheOperate<ENTITY extends Entity<ID>, ID extends Serializable>
extends ResourceCacheOperate<ENTITY, ID> {
    public HashResourceCacheOperate(RedisTemplate<String, ENTITY> redisTemplate, String key, Duration timeout) {
        super(redisTemplate, key, timeout);
    }

    @Override
    public void addCache(ENTITY entity) {
        this.refreshCache(entity);
    }

    @Override
    public void refreshCache(ENTITY entity) {
        this.redisTemplate.opsForHash().put((Object)this.key, (Object)String.valueOf(entity.getId()), entity);
    }

    @Override
    public void deleteCache(ENTITY entity) {
        this.redisTemplate.opsForHash().delete((Object)this.key, new Object[]{String.valueOf(entity.getId())});
    }

    @Override
    public Optional<ENTITY> readCache(ID id) {
        return Optional.ofNullable((Entity)this.redisTemplate.opsForHash().get((Object)this.key, (Object)String.valueOf(id)));
    }
}

