/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring.cache;

import com.github.developframework.resource.Entity;
import com.github.developframework.resource.spring.cache.RedisCacheHelper;
import com.github.developframework.resource.spring.cache.ResourceCacheOperate;
import develop.toolkit.base.struct.KeyValuePair;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.springframework.data.redis.core.RedisTemplate;

public class ListResourceCacheOperate<ENTITY extends Entity<ID>, ID extends Serializable>
extends ResourceCacheOperate<ENTITY, ID> {
    public ListResourceCacheOperate(RedisTemplate<String, ENTITY> redisTemplate, String key, Duration timeout) {
        super(redisTemplate, key, timeout);
    }

    @Override
    public void addCache(ENTITY entity) {
        this.redisTemplate.opsForList().rightPush((Object)this.key, entity);
    }

    @Override
    public void refreshCache(ENTITY entity) {
        KeyValuePair<Long, Entity> kv;
        if (RedisCacheHelper.hasKey(this.redisTemplate, this.key) && (Long)(kv = RedisCacheHelper.listFind(this.redisTemplate, this.key, p -> p.getId().equals(entity.getId()))).getKey() >= 0L) {
            this.redisTemplate.opsForList().set((Object)this.key, ((Long)kv.getKey()).longValue(), entity);
            return;
        }
        this.addCache(entity);
    }

    @Override
    public void deleteCache(ENTITY entity) {
        this.readCache(entity.getId()).ifPresent(e -> this.redisTemplate.opsForList().remove((Object)this.key, 1L, e));
    }

    @Override
    public Optional<ENTITY> readCache(ID id) {
        return Optional.ofNullable((Entity)RedisCacheHelper.listFind(this.redisTemplate, this.key, p -> p.getId().equals(id)).getValue());
    }
}

