/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.spring.cache;

import develop.toolkit.base.struct.KeyValuePair;
import develop.toolkit.base.struct.KeyValuePairs;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public final class RedisCacheHelper {
    public static <K, V> boolean hasKey(RedisTemplate<K, V> redisTemplate, K key) {
        Boolean hasKey = redisTemplate.hasKey(key);
        return hasKey != null && hasKey != false;
    }

    public static <K, V> long listSize(RedisTemplate<K, V> redisTemplate, K key) {
        Long size = redisTemplate.opsForList().size(key);
        return size != null ? size : 0L;
    }

    public static <K, V> boolean listNotEmpty(RedisTemplate<K, V> redisTemplate, K key) {
        Long size = redisTemplate.opsForList().size(key);
        return size != null && size > 0L;
    }

    public static <K, V> boolean listEmpty(RedisTemplate<K, V> redisTemplate, K key) {
        Long size = redisTemplate.opsForList().size(key);
        return size == null || size == 0L;
    }

    public static <K, V> KeyValuePair<Long, V> listFind(RedisTemplate<K, V> redisTemplate, K key, Predicate<V> predicate) {
        ListOperations listOperations = redisTemplate.opsForList();
        long size = RedisCacheHelper.listSize(redisTemplate, key);
        for (long i = 0L; i < size; ++i) {
            Object v = listOperations.index(key, i);
            if (v == null || !predicate.test(v)) continue;
            return KeyValuePair.of((Object)i, (Object)v);
        }
        return KeyValuePair.of((Object)-1L, null);
    }

    public static <K, V> KeyValuePairs<Long, V> listFindAll(RedisTemplate<K, V> redisTemplate, K key, Predicate<V> predicate) {
        KeyValuePairs keyValuePairs = new KeyValuePairs();
        ListOperations listOperations = redisTemplate.opsForList();
        long size = RedisCacheHelper.listSize(redisTemplate, key);
        for (long i = 0L; i < size; ++i) {
            Object v = listOperations.index(key, i);
            if (v == null || !predicate.test(v)) continue;
            keyValuePairs.addKeyValue((Object)i, v);
        }
        return keyValuePairs;
    }

    public static <K, V> V readValue(RedisTemplate<K, V> redisTemplate, K key, Duration timeout, Supplier<V> defaultSupplier) {
        ValueOperations valueOperations = redisTemplate.opsForValue();
        Object v = valueOperations.get(key);
        if (v == null && (v = defaultSupplier.get()) != null) {
            if (timeout != null) {
                valueOperations.set(key, v, timeout);
            } else {
                valueOperations.set(key, v);
            }
        }
        return (V)v;
    }

    public static <H, HK, HV> HV readHash(RedisTemplate<H, HV> redisTemplate, H key, HK hashKey, Supplier<HV> defaultSupplier) {
        HashOperations hashOperations = redisTemplate.opsForHash();
        Object v = hashOperations.get(key, hashKey);
        if (v == null && (v = defaultSupplier.get()) != null) {
            hashOperations.put(key, hashKey, v);
        }
        return (HV)v;
    }

    public static <K, V> void deleteKeys(RedisTemplate<K, V> redisTemplate, K pattern) {
        Set keys = redisTemplate.keys(pattern);
        if (keys != null) {
            redisTemplate.delete((Collection)keys);
        }
    }
}

