/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay;

import org.develop.wechatpay.WechatConfiguration;
import org.develop.wechatpay.WechatPayApiClient;
import org.develop.wechatpay.converter.BaseAnnotationXmlDeserializer;
import org.develop.wechatpay.converter.BaseAnnotationXmlSerializer;
import org.develop.wechatpay.entity.WechatEntity;
import org.develop.wechatpay.entity.WechatPayNotifyInfo;
import org.develop.wechatpay.entity.WechatPayNotifyResponseEntity;
import org.develop.wechatpay.utils.Assert;
import org.develop.wechatpay.utils.PropertyUtils;

public final class WechatPay {
    public static final String DEFAULT_PROPERTIES = "/wechat-pay.properties";

    public static WechatPayApiClient createClient() {
        return WechatPay.createClient(DEFAULT_PROPERTIES);
    }

    public static WechatPayApiClient createClient(String propertyfilename) {
        WechatConfiguration wechatConfiguration = PropertyUtils.readProperties(propertyfilename, WechatConfiguration.class);
        Assert.nonBlank(wechatConfiguration.getAppid(), "wechat.info.appid undefined");
        Assert.nonBlank(wechatConfiguration.getMchId(), "wechat.info.mch_id undefined");
        return new WechatPayApiClient(wechatConfiguration);
    }

    public static WechatEntity<WechatPayNotifyInfo> parseWechatPayNotify(String xml) {
        Assert.nonBlank(xml, "xml is required!");
        BaseAnnotationXmlDeserializer<WechatPayNotifyInfo> xmlDeserializer = new BaseAnnotationXmlDeserializer<WechatPayNotifyInfo>();
        return xmlDeserializer.deserialize(xml, WechatPayNotifyInfo.class);
    }

    public static String makeResponseForNotify(WechatPayNotifyResponseEntity entity) {
        Assert.nonNull(entity);
        Assert.nonBlank(entity.getReturnCode(), "returnCode is required!");
        BaseAnnotationXmlSerializer<WechatPayNotifyResponseEntity> xmlSerializer = new BaseAnnotationXmlSerializer<WechatPayNotifyResponseEntity>();
        return xmlSerializer.serialize(entity, null);
    }
}

