/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay;

import org.develop.wechatpay.APIURL;
import org.develop.wechatpay.ApiRequestor;
import org.develop.wechatpay.WechatConfiguration;
import org.develop.wechatpay.WechatPayApi;
import org.develop.wechatpay.entity.OrderQueryInfo;
import org.develop.wechatpay.entity.OrderQueryRequestEntity;
import org.develop.wechatpay.entity.UnifiedOrderInfo;
import org.develop.wechatpay.entity.UnifiedOrderRequestEntity;
import org.develop.wechatpay.entity.WechatEntity;
import org.develop.wechatpay.utils.Assert;
import org.develop.wechatpay.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayApiClient
extends ApiRequestor
implements WechatPayApi {
    private static final Logger log = LoggerFactory.getLogger(WechatPayApiClient.class);
    private WechatConfiguration wechatConfiguration;
    private APIURL apiurl;

    public WechatPayApiClient(WechatConfiguration wechatConfiguration) {
        Assert.nonNull(wechatConfiguration, "wechatPayConfiguration must not null!");
        Assert.nonBlank(wechatConfiguration.getAppid(), "appid is required!");
        Assert.nonBlank(wechatConfiguration.getMchId(), "mchId is required!");
        this.wechatConfiguration = wechatConfiguration;
        this.apiurl = PropertyUtils.readProperties("/wechat-pay-api.properties", APIURL.class);
    }

    @Override
    public WechatEntity<UnifiedOrderInfo> unifiedOrder(UnifiedOrderRequestEntity unifiedOrderRequestEntity) {
        log.debug("client deal unified order");
        unifiedOrderRequestEntity.setAppid(this.wechatConfiguration.getAppid());
        unifiedOrderRequestEntity.setMchId(this.wechatConfiguration.getMchId());
        return super.api(this.wechatConfiguration, this.apiurl.UNIFIED_ORDER, unifiedOrderRequestEntity, UnifiedOrderInfo.class);
    }

    @Override
    public WechatEntity<OrderQueryInfo> orderQuery(OrderQueryRequestEntity orderQueryRequestEntity) {
        log.debug("client deal order query");
        orderQueryRequestEntity.setAppid(this.wechatConfiguration.getAppid());
        orderQueryRequestEntity.setMchId(this.wechatConfiguration.getMchId());
        return super.api(this.wechatConfiguration, this.apiurl.ORDER_QUERY, orderQueryRequestEntity, OrderQueryInfo.class);
    }

    public WechatConfiguration getWechatConfiguration() {
        return this.wechatConfiguration;
    }

    public APIURL getApiurl() {
        return this.apiurl;
    }
}

