/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay.converter;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.develop.wechatpay.annotation.XmlElement;
import org.develop.wechatpay.annotation.XmlElementArray;
import org.develop.wechatpay.utils.Util;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlComponent {
    private static final Logger log = LoggerFactory.getLogger(AbstractXmlComponent.class);

    protected void printXML(Document document) {
        if (log.isInfoEnabled()) {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setExpandEmptyElements(true);
            format.setSuppressDeclaration(true);
            StringWriter stringWriter = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
            try {
                writer.write(document);
                log.info(stringWriter.toString());
            }
            catch (IOException e) {
                Util.catchException(e);
            }
        }
    }

    protected String elementText(Element root, XmlElement xmlElement) {
        Element element = root.element(xmlElement.value());
        return Objects.nonNull(element) ? element.getTextTrim() : null;
    }

    protected Iterator<Field> iteratorHasXmlAnnotation(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredFields()).stream().filter(field -> Objects.nonNull(field.getAnnotation(XmlElement.class)) | Objects.nonNull(field.getAnnotation(XmlElementArray.class))).iterator();
    }
}

