/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay.converter;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Objects;
import org.develop.wechatpay.annotation.XmlElement;
import org.develop.wechatpay.annotation.XmlElementArray;
import org.develop.wechatpay.converter.AbstractXmlComponent;
import org.develop.wechatpay.converter.XmlDeserializer;
import org.develop.wechatpay.entity.ReturnSuccessResponse;
import org.develop.wechatpay.entity.WechatEntity;
import org.develop.wechatpay.utils.Util;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BaseAnnotationXmlDeserializer<INFO>
extends AbstractXmlComponent
implements XmlDeserializer<INFO> {
    @Override
    public WechatEntity<INFO> deserialize(String xml, Class<INFO> clazz) {
        try {
            Document document = DocumentHelper.parseText((String)xml);
            super.printXML(document);
            Element root = document.getRootElement();
            WechatEntity<INFO> entity = this.makeWechatEntity(root);
            if (entity.isReturnSuccess()) {
                ReturnSuccessResponse returnSuccessResponse = this.dealSinpleEntity(root, ReturnSuccessResponse.class);
                entity.setReturnSuccessResponse(returnSuccessResponse);
                if (returnSuccessResponse.isResultSuccess()) {
                    INFO resultSuccessResponseInfo = this.dealSinpleEntity(root, clazz);
                    returnSuccessResponse.setResultSuccessResponseInfo(resultSuccessResponseInfo);
                }
            }
            return entity;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | DocumentException e) {
            Util.catchException(e);
            return null;
        }
    }

    private WechatEntity<INFO> makeWechatEntity(Element root) throws IllegalArgumentException, IllegalAccessException {
        WechatEntity entity = new WechatEntity();
        Iterator<Field> iterator = super.iteratorHasXmlAnnotation(WechatEntity.class);
        while (iterator.hasNext()) {
            Field field = iterator.next();
            field.setAccessible(true);
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            String text = super.elementText(root, xmlElement);
            field.set(entity, text);
        }
        return entity;
    }

    private <E> E dealSinpleEntity(Element root, Class<E> clazz) throws InstantiationException, IllegalAccessException {
        E entity = clazz.newInstance();
        Iterator<Field> iterator = super.iteratorHasXmlAnnotation(clazz);
        while (iterator.hasNext()) {
            Element indexElement;
            Element element;
            Field field = iterator.next();
            field.setAccessible(true);
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            XmlElementArray xmlElementArray = field.getAnnotation(XmlElementArray.class);
            if (Objects.nonNull(xmlElement) && Objects.nonNull(element = root.element(xmlElement.value()))) {
                if (field.getType() == Integer.class) {
                    field.set(entity, new Integer(element.getTextTrim()));
                } else {
                    field.set(entity, element.getTextTrim());
                }
            }
            if (!Objects.nonNull(xmlElementArray) || !Objects.nonNull(indexElement = root.element(xmlElementArray.indexElement()))) continue;
            int size = new Integer(indexElement.getTextTrim());
            Class<?> componentType = field.getType().getComponentType();
            Object array = Array.newInstance(componentType, size);
            for (int i = 0; i < size; ++i) {
                Element element2 = root.element(xmlElementArray.value().replace("$n", String.valueOf(i)));
                if (!Objects.nonNull(element2)) continue;
                String text = element2.getTextTrim();
                if (componentType == Integer.class) {
                    Array.setInt(array, i, new Integer(text));
                    continue;
                }
                Array.set(array, i, text);
            }
            field.set(entity, array);
        }
        return entity;
    }
}

