/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay.converter;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.develop.wechatpay.annotation.SignElement;
import org.develop.wechatpay.annotation.XmlElement;
import org.develop.wechatpay.converter.AbstractXmlComponent;
import org.develop.wechatpay.converter.XmlSerializer;
import org.develop.wechatpay.utils.Assert;
import org.develop.wechatpay.utils.Util;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BaseAnnotationXmlSerializer<T>
extends AbstractXmlComponent
implements XmlSerializer<T> {
    @Override
    public String serialize(T t, String apiKey) {
        Element root = DocumentHelper.createElement((String)"xml");
        Document document = DocumentHelper.createDocument((Element)root);
        this.checkRequestPropertyValidAndAddElement(root, t, apiKey);
        this.printXML(document);
        return root.asXML();
    }

    protected void checkRequestPropertyValidAndAddElement(Element root, T t, String APIKey) {
        Field sign = null;
        Iterator<Field> iterator = super.iteratorHasXmlAnnotation(t.getClass());
        while (iterator.hasNext()) {
            Field field = iterator.next();
            XmlElement xmlElement = field.getAnnotation(XmlElement.class);
            SignElement signElement = field.getAnnotation(SignElement.class);
            if (xmlElement == null) continue;
            if (signElement != null) {
                sign = field;
                continue;
            }
            try {
                field.setAccessible(true);
                Object value = field.get(t);
                if (xmlElement.notNull() && value == null) {
                    String fieldName = field.getName();
                    throw new IllegalArgumentException(fieldName + " must not null!");
                }
                this.addElement(root, xmlElement.value(), value, !xmlElement.notNull());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (sign != null) {
            XmlElement xmlElement = sign.getAnnotation(XmlElement.class);
            String signStr = Util.generateSign(t, APIKey);
            this.addElement(root, xmlElement.value(), signStr, !xmlElement.notNull());
        }
    }

    private void addElement(Element root, String elementName, Object obj, boolean allowNull) {
        if (obj == null && allowNull) {
            return;
        }
        Assert.nonNull(obj, elementName);
        root.addElement(elementName).setText(obj.toString());
    }
}

