/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay.utils;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Objects;
import java.util.Properties;
import org.develop.wechatpay.WechatPay;
import org.develop.wechatpay.annotation.Property;
import org.develop.wechatpay.utils.Util;

public final class PropertyUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readProperties(String propertyfilename, Class<T> clazz) {
        Properties pps = new Properties();
        try {
            InputStream is = WechatPay.class.getResourceAsStream(propertyfilename);
            try {
                Field[] fields;
                if (is == null) {
                    throw new FileNotFoundException(propertyfilename + " is not found.");
                }
                pps.load(is);
                T t2 = clazz.newInstance();
                for (Field field : fields = clazz.getDeclaredFields()) {
                    field.setAccessible(true);
                    Property propertyAnnotation = field.getAnnotation(Property.class);
                    if (!Objects.nonNull(propertyAnnotation)) continue;
                    String value = pps.getProperty(propertyAnnotation.key(), propertyAnnotation.defValue());
                    if (field.getType() == Boolean.TYPE) {
                        field.setBoolean(t2, new Boolean(value));
                        continue;
                    }
                    if (field.getType() == Integer.TYPE) {
                        field.setInt(t2, new Integer(value));
                        continue;
                    }
                    field.set(t2, value);
                }
                T t = t2;
                return t;
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    is.close();
                }
            }
        }
        catch (Exception e) {
            Util.catchException(e);
            return null;
        }
    }
}

