/*
 * Decompiled with CFR 0.152.
 */
package org.develop.wechatpay.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.develop.wechatpay.annotation.Entity;
import org.develop.wechatpay.annotation.SignElement;
import org.develop.wechatpay.annotation.XmlElement;
import org.develop.wechatpay.entity.SinpleField;
import org.develop.wechatpay.exception.WechatPayException;
import org.develop.wechatpay.utils.ASCIIComparator;
import org.develop.wechatpay.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static void catchException(Throwable e) {
        e.printStackTrace();
        throw new WechatPayException(e);
    }

    public static String generateSign(Object entity, String APIKey) {
        Assert.nonNull(entity);
        Assert.nonBlank(APIKey, "APIKey is not null");
        ArrayList<String> list = new ArrayList<String>();
        Iterator<SinpleField> iterator = Util.getSinpleFieldIterator(entity);
        while (iterator.hasNext()) {
            SinpleField sinpleField = iterator.next();
            list.add(sinpleField.toString());
        }
        list.add("key=" + APIKey);
        String unEncrypt = String.join((CharSequence)"&", list);
        return DigestUtils.md5Hex((String)unEncrypt).toUpperCase();
    }

    public static boolean checkSign(Object entity, String APIKey, String targetSign) {
        String sign = Util.generateSign(entity, APIKey);
        log.info(sign);
        return sign.equals(targetSign);
    }

    private static Iterator<SinpleField> getSinpleFieldIterator(Object entity) {
        LinkedList<SinpleField> list = new LinkedList<SinpleField>();
        Util.dealSinpleEntity(list, entity);
        ASCIIComparator<SinpleField> asciiComparator = new ASCIIComparator<SinpleField>(sinpleField -> sinpleField.getFieldName());
        return list.stream().sorted(asciiComparator).iterator();
    }

    private static void dealSinpleEntity(List<SinpleField> list, Object entity) {
        Field[] fields;
        for (Field field : fields = entity.getClass().getDeclaredFields()) {
            try {
                XmlElement xmlElementAnnotation = field.getAnnotation(XmlElement.class);
                SignElement signElementAnnotation = field.getAnnotation(SignElement.class);
                if (Objects.nonNull(xmlElementAnnotation) && Objects.isNull(signElementAnnotation)) {
                    field.setAccessible(true);
                    Object value = field.get(entity);
                    if (value == null) continue;
                    list.add(new SinpleField(xmlElementAnnotation.value(), value));
                    continue;
                }
                if (!Objects.nonNull(field.getAnnotation(Entity.class))) continue;
                field.setAccessible(true);
                Object nextEntity = field.get(entity);
                Util.dealSinpleEntity(list, nextEntity);
            }
            catch (Exception e) {
                Util.catchException(e);
            }
        }
    }

    public static String randomNonceStr(int count) {
        return RandomStringUtils.randomAlphanumeric((int)count);
    }
}

