/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor;

import com.github.dexecutor.executor.DependentTasksExecutor;
import com.github.dexecutor.executor.DependentTasksExecutorConfig;
import com.github.dexecutor.executor.TaskProvider;
import com.github.dexecutor.executor.graph.DefaultGraph;
import com.github.dexecutor.executor.graph.Graph;
import com.github.dexecutor.executor.graph.Traversar;
import com.github.dexecutor.executor.graph.Validator;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultDependentTasksExecutor<T extends Comparable<T>>
implements DependentTasksExecutor<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDependentTasksExecutor.class);
    private ExecutorService executorService;
    private TaskProvider<T> taskProvider;
    private Validator<T> validator;
    private Traversar<T> traversar;
    private Graph<T> graph;
    private Collection<Graph.Node<T>> processedNodes = new CopyOnWriteArrayList<Graph.Node<T>>();
    private AtomicInteger nodesCount = new AtomicInteger(0);

    public DefaultDependentTasksExecutor(ExecutorService executorService, TaskProvider<T> taskProvider) {
        this(new DependentTasksExecutorConfig<T>(executorService, taskProvider));
    }

    public DefaultDependentTasksExecutor(DependentTasksExecutorConfig<T> config) {
        config.validate();
        this.executorService = config.getExecutorService();
        this.taskProvider = config.getTaskProvider();
        this.validator = config.getValidator();
        this.traversar = config.getTraversar();
        this.graph = new DefaultGraph();
    }

    @Override
    public void print(Writer writer) {
        this.traversar.traverse(this.graph, writer);
    }

    @Override
    public void addIndependent(T nodeValue) {
        this.graph.addIndependent(nodeValue);
    }

    @Override
    public void addDependency(T evalFirstNode, T evalLaterNode) {
        this.graph.addDependency(evalFirstNode, evalLaterNode);
    }

    @Override
    public void addAsDependencyToAllLeafNodes(T nodeValue) {
        if (this.graph.size() == 0) {
            this.addIndependent(nodeValue);
        } else {
            for (Graph.Node<T> node : this.graph.getLeafNodes()) {
                this.addDependency((Comparable)node.getValue(), nodeValue);
            }
        }
    }

    private boolean isAlreadyProcessed(Graph.Node<T> node) {
        return this.processedNodes.contains(node);
    }

    private boolean areAlreadyProcessed(Set<Graph.Node<T>> nodes) {
        return this.processedNodes.containsAll(nodes);
    }

    @Override
    public void execute(DependentTasksExecutor.ExecutionBehavior behavior) {
        this.validate();
        Set<Graph.Node<T>> initialNodes = this.graph.getInitialNodes();
        ExecutorCompletionService<Graph.Node<T>> completionService = new ExecutorCompletionService<Graph.Node<T>>(this.executorService);
        long start = new Date().getTime();
        this.doProcessNodes(behavior, initialNodes, completionService);
        long end = new Date().getTime();
        logger.debug("Total Time taken to process {} jobs is {} ms.", (Object)this.graph.size(), (Object)(end - start));
        logger.debug("Processed Nodes Ordering {}", this.processedNodes);
    }

    private void doProcessNodes(DependentTasksExecutor.ExecutionBehavior behavior, Set<Graph.Node<T>> nodes, CompletionService<Graph.Node<T>> completionService) {
        this.doExecute(nodes, completionService, behavior);
        this.doWaitForExecution(completionService, behavior);
    }

    private void validate() {
        this.validator.validate(this.graph);
    }

    private void doExecute(Collection<Graph.Node<T>> nodes, CompletionService<Graph.Node<T>> completionService, DependentTasksExecutor.ExecutionBehavior behavior) {
        for (Graph.Node<T> node : nodes) {
            if (this.shouldProcess(node)) {
                this.nodesCount.incrementAndGet();
                logger.debug("Going to schedule {} node", node.getValue());
                completionService.submit(this.newTask(node, behavior));
                continue;
            }
            logger.debug("node {} depends on {}", node.getValue(), node.getInComingNodes());
        }
    }

    private boolean shouldProcess(Graph.Node<T> node) {
        return !this.executorService.isShutdown() && !this.isAlreadyProcessed(node) && this.allIncomingNodesProcessed(node);
    }

    private boolean allIncomingNodesProcessed(Graph.Node<T> node) {
        return node.getInComingNodes().isEmpty() || this.areAlreadyProcessed(node.getInComingNodes());
    }

    private void doWaitForExecution(CompletionService<Graph.Node<T>> completionService, DependentTasksExecutor.ExecutionBehavior behavior) {
        int cuurentCount = 0;
        while (cuurentCount != this.nodesCount.get()) {
            try {
                Future<Graph.Node<T>> future = completionService.take();
                Graph.Node<T> processedNode = future.get();
                logger.debug("Processing of node {} done", processedNode.getValue());
                ++cuurentCount;
                this.processedNodes.add(processedNode);
                this.doExecute(processedNode.getOutGoingNodes(), completionService, behavior);
            }
            catch (Exception e) {
                ++cuurentCount;
                logger.error("Task interrupted", (Throwable)e);
            }
        }
    }

    private Callable<Graph.Node<T>> newTask(Graph.Node<T> graphNode, DependentTasksExecutor.ExecutionBehavior behavior) {
        if (DependentTasksExecutor.ExecutionBehavior.NON_TERMINATING.equals((Object)behavior)) {
            return new NonTerminatingTask(graphNode);
        }
        if (DependentTasksExecutor.ExecutionBehavior.RETRY_ONCE_TERMINATING.equals((Object)behavior)) {
            return new RetryOnceAndTerminateTask(graphNode);
        }
        return new TerminatingTask(graphNode);
    }

    protected boolean shouldRetry(T node) {
        return true;
    }

    private TaskProvider.Task newTask(T taskId) {
        return new LoggingTask(this, taskId, this.taskProvider.provid(taskId));
    }

    private static class LoggingTask
    extends TaskProvider.Task {
        private final TaskProvider.Task task;
        private final T taskId;
        private int retryCount = 0;
        final /* synthetic */ DefaultDependentTasksExecutor this$0;

        public LoggingTask(T taskId, TaskProvider.Task task) {
            this.this$0 = var1_1;
            this.task = task;
            this.taskId = taskId;
        }

        @Override
        public void execute() {
            logger.debug("{} Node # {}", (Object)this.msg(this.retryCount), this.taskId);
            ++this.retryCount;
            this.task.execute();
            logger.debug("Node # {}, Execution Done!", this.taskId);
        }

        private String msg(int retryCount) {
            return retryCount > 0 ? "Retrying(" + retryCount + ") " : "Executing";
        }

        @Override
        void setConsiderExecutionError(boolean considerExecutionError) {
            this.task.setConsiderExecutionError(considerExecutionError);
        }
    }

    private class RetryOnceAndTerminateTask
    implements Callable<Graph.Node<T>> {
        private Graph.Node<T> node;

        public RetryOnceAndTerminateTask(Graph.Node<T> graphNode) {
            this.node = graphNode;
        }

        @Override
        public Graph.Node<T> call() throws Exception {
            block2: {
                TaskProvider.Task task = DefaultDependentTasksExecutor.this.newTask((Comparable)this.node.getValue());
                boolean retry = DefaultDependentTasksExecutor.this.shouldRetry((Comparable)this.node.getValue());
                task.setConsiderExecutionError(!retry);
                try {
                    task.execute();
                }
                catch (Exception ex) {
                    logger.error("Exception caught, executing node # " + this.node.getValue() + " Retry would happen : " + this.getYesNo(retry), (Throwable)ex);
                    if (!retry) break block2;
                    task.setConsiderExecutionError(true);
                    task.execute();
                }
            }
            return this.node;
        }

        private String getYesNo(boolean retry) {
            return retry ? "Yes" : "No";
        }
    }

    private class NonTerminatingTask
    implements Callable<Graph.Node<T>> {
        private Graph.Node<T> node;

        public NonTerminatingTask(Graph.Node<T> graphNode) {
            this.node = graphNode;
        }

        @Override
        public Graph.Node<T> call() throws Exception {
            try {
                TaskProvider.Task task = DefaultDependentTasksExecutor.this.newTask((Comparable)this.node.getValue());
                task.setConsiderExecutionError(false);
                task.execute();
            }
            catch (Exception ex) {
                logger.error("Exception caught, executing node # " + this.node.getValue(), (Throwable)ex);
            }
            return this.node;
        }
    }

    private class TerminatingTask
    implements Callable<Graph.Node<T>> {
        private Graph.Node<T> node;

        public TerminatingTask(Graph.Node<T> graphNode) {
            this.node = graphNode;
        }

        @Override
        public Graph.Node<T> call() throws Exception {
            TaskProvider.Task task = DefaultDependentTasksExecutor.this.newTask((Comparable)this.node.getValue());
            task.setConsiderExecutionError(true);
            task.execute();
            return this.node;
        }
    }
}

