/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor;

import com.github.dexecutor.executor.TaskProvider;
import com.github.dexecutor.executor.graph.CyclicValidator;
import com.github.dexecutor.executor.graph.LevelOrderTraversar;
import com.github.dexecutor.executor.graph.Traversar;
import com.github.dexecutor.executor.graph.Validator;
import com.github.dexecutor.executor.support.Preconditions;
import java.util.concurrent.ExecutorService;

public class DependentTasksExecutorConfig<T extends Comparable<T>> {
    private ExecutorService executorService;
    private TaskProvider<T> taskProvider;
    private Validator<T> validator = new CyclicValidator();
    private Traversar<T> traversar = new LevelOrderTraversar();

    public DependentTasksExecutorConfig(ExecutorService executorService, TaskProvider<T> taskProvider) {
        this.executorService = executorService;
        this.taskProvider = taskProvider;
    }

    void validate() {
        Preconditions.checkNotNull(this.executorService, "Executer Service should not be null");
        Preconditions.checkNotNull(this.taskProvider, "Task Provider should not be null");
        Preconditions.checkNotNull(this.validator, "Validator should not be null");
        Preconditions.checkNotNull(this.validator, "Traversar should not be null");
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    TaskProvider<T> getTaskProvider() {
        return this.taskProvider;
    }

    Validator<T> getValidator() {
        return this.validator;
    }

    public void setValidator(Validator<T> validator) {
        this.validator = validator;
    }

    Traversar<T> getTraversar() {
        return this.traversar;
    }

    public void setTraversar(Traversar<T> traversar) {
        this.traversar = traversar;
    }
}

