/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor.graph;

import com.github.dexecutor.executor.graph.Graph;
import com.github.dexecutor.executor.graph.Validator;
import java.util.ArrayList;
import java.util.Collection;

public class CyclicValidator<T extends Comparable<T>>
implements Validator<T> {
    private Collection<Graph.Node<T>> processedNodes = new ArrayList<Graph.Node<T>>();
    private Collection<Graph.Node<T>> onStackNodes = new ArrayList<Graph.Node<T>>();

    @Override
    public void validate(Graph<T> graph) {
        this.doProcess(graph.allNodes());
    }

    private void doProcess(Collection<Graph.Node<T>> nodes) {
        for (Graph.Node<T> node : nodes) {
            this.detectCycle(node);
        }
    }

    private void detectCycle(Graph.Node<T> node) {
        this.processedNodes.add(node);
        this.onStackNodes.add(node);
        this.doDepthFirstTraversal(node);
        this.onStackNodes.remove(node);
    }

    private void doDepthFirstTraversal(Graph.Node<T> node) {
        for (Graph.Node<T> adjNode : node.getOutGoingNodes()) {
            if (!this.isAlreadyProcessed(adjNode)) {
                this.detectCycle(adjNode);
                continue;
            }
            if (!this.isOnStack(adjNode)) continue;
            throw new IllegalArgumentException("Cycle Detected " + node + " With " + adjNode);
        }
    }

    private boolean isAlreadyProcessed(Graph.Node<T> node) {
        return this.processedNodes.contains(node);
    }

    private boolean isOnStack(Graph.Node<T> node) {
        return this.onStackNodes.contains(node);
    }
}

