/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor.graph;

import com.github.dexecutor.executor.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DefaultGraph<T extends Comparable<T>>
implements Graph<T> {
    private Map<T, Graph.Node<T>> nodes = new HashMap<T, Graph.Node<T>>();

    @Override
    public void addIndependent(T nodeValue) {
        this.doAdd(nodeValue);
    }

    @Override
    public void addDependency(T evalFirstNode, T evalLaterNode) {
        Graph.Node<T> firstNode = this.doAdd(evalFirstNode);
        Graph.Node<T> afterNode = this.doAdd(evalLaterNode);
        firstNode.addOutGoingNode(afterNode);
        afterNode.addInComingNode(firstNode);
    }

    private Graph.Node<T> doAdd(T nodeValue) {
        Graph.Node<T> graphNode = null;
        if (this.nodes.containsKey(nodeValue)) {
            graphNode = this.nodes.get(nodeValue);
        } else {
            graphNode = this.createNode(nodeValue);
            this.nodes.put(nodeValue, graphNode);
        }
        return graphNode;
    }

    private Graph.Node<T> createNode(T value) {
        Graph.Node<T> node = new Graph.Node<T>(value);
        return node;
    }

    @Override
    public Set<Graph.Node<T>> getInitialNodes() {
        LinkedHashSet<Graph.Node<T>> initialNodes = new LinkedHashSet<Graph.Node<T>>();
        Set<T> keys = this.nodes.keySet();
        for (Comparable key : keys) {
            Graph.Node<T> node = this.nodes.get(key);
            if (!node.getInComingNodes().isEmpty()) continue;
            initialNodes.add(node);
        }
        return initialNodes;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public Collection<Graph.Node<T>> allNodes() {
        return new ArrayList<Graph.Node<T>>(this.nodes.values());
    }

    @Override
    public Set<Graph.Node<T>> getLeafNodes() {
        LinkedHashSet<Graph.Node<T>> leafNodes = new LinkedHashSet<Graph.Node<T>>();
        Set<T> keys = this.nodes.keySet();
        for (Comparable key : keys) {
            Graph.Node<T> node = this.nodes.get(key);
            if (!node.getOutGoingNodes().isEmpty()) continue;
            leafNodes.add(node);
        }
        return leafNodes;
    }
}

