/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor.graph;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public interface Graph<T extends Comparable<T>> {
    public void addDependency(T var1, T var2);

    public void addIndependent(T var1);

    public Set<Node<T>> getInitialNodes();

    public Set<Node<T>> getLeafNodes();

    public Collection<Node<T>> allNodes();

    public int size();

    public static final class Node<T> {
        private T value;
        private Set<Node<T>> inComingEdges = new LinkedHashSet<Node<T>>();
        private Set<Node<T>> outGoingEdges = new LinkedHashSet<Node<T>>();

        public Node(T val) {
            this.value = val;
        }

        public void addInComingNode(Node<T> node) {
            this.inComingEdges.add(node);
        }

        public void addOutGoingNode(Node<T> node) {
            this.outGoingEdges.add(node);
        }

        public Set<Node<T>> getInComingNodes() {
            return this.inComingEdges;
        }

        public Set<Node<T>> getOutGoingNodes() {
            return this.outGoingEdges;
        }

        public T getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            return this.value.equals(other.value);
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

