/*
 * Decompiled with CFR 0.152.
 */
package com.github.dexecutor.executor.graph;

import com.github.dexecutor.executor.graph.Graph;
import com.github.dexecutor.executor.graph.Traversar;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class LevelOrderTraversar<T extends Comparable<T>>
implements Traversar<T> {
    private List<Graph.Node<T>> processed = new ArrayList<Graph.Node<T>>();

    @Override
    public void traverse(Graph<T> graph, Writer writer) {
        List<List<List<Graph.Node<T>>>> levelOrderOfGraphs = this.traverseLevelOrder(graph);
        int i = 0;
        for (List<List<Graph.Node<T>>> levelOrderOfGraph : levelOrderOfGraphs) {
            try {
                writer.write("Path #" + i++ + "\n");
                this.printGraph(levelOrderOfGraph, writer);
                writer.write("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<List<List<Graph.Node<T>>>> traverseLevelOrder(Graph<T> graph) {
        ArrayList<List<List<Graph.Node<T>>>> result = new ArrayList<List<List<Graph.Node<T>>>>();
        Set<Graph.Node<T>> initialNodes = graph.getInitialNodes();
        for (Graph.Node<T> iNode : initialNodes) {
            ArrayList<List<Graph.Node<T>>> iresult = new ArrayList<List<Graph.Node<T>>>();
            this.doTraverse(iresult, iNode);
            result.add(iresult);
        }
        return result;
    }

    private void doTraverse(List<List<Graph.Node<T>>> result, Graph.Node<T> iNode) {
        LinkedList queue = new LinkedList();
        queue.offer(iNode);
        while (!queue.isEmpty()) {
            ArrayList<Graph.Node> level = new ArrayList<Graph.Node>();
            int size = queue.size();
            for (int i = 0; i < size; ++i) {
                Graph.Node node = (Graph.Node)queue.poll();
                if (this.processed.contains(node)) continue;
                if (!level.contains(node)) {
                    level.add(node);
                }
                this.processed.add(node);
                for (Graph.Node ogn : node.getOutGoingNodes()) {
                    if (ogn == null || this.processed.contains(ogn)) continue;
                    queue.offer(ogn);
                }
            }
            result.add(level);
        }
    }

    private void printGraph(List<List<Graph.Node<T>>> list, Writer writer) {
        for (List<Graph.Node<T>> nodes : list) {
            try {
                for (Graph.Node<T> node : nodes) {
                    writer.write(node + "" + node.getInComingNodes() + " ");
                }
                writer.write("\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

