/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.extensions.http;

import java.io.InputStreamReader;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.metricssampler.config.BaseHttpInputConfig;
import org.metricssampler.extensions.http.HttpInputConfig;
import org.metricssampler.extensions.http.HttpResponseParser;
import org.metricssampler.reader.BaseHttpMetricsReader;

public class HttpMetricsReader
extends BaseHttpMetricsReader<HttpInputConfig> {
    protected final HttpResponseParser parser;

    public HttpMetricsReader(HttpInputConfig config) {
        super((BaseHttpInputConfig)config);
        this.parser = config.getParser();
    }

    protected void processResponse(HttpUriRequest request, HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStreamReader reader = this.streamEntity(entity);){
                this.values = this.parser.parse(response, entity, reader);
            }
        } else {
            this.values = Collections.emptyMap();
            this.logger.warn("Response was null. Response line: {}", (Object)response.getStatusLine());
        }
    }
}

