/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.extensions.http.parsers.regexp;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.LineIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.metricssampler.extensions.http.HttpResponseParser;
import org.metricssampler.extensions.http.parsers.regexp.RegExpLineFormat;
import org.metricssampler.reader.MetricName;
import org.metricssampler.reader.MetricValue;

public class RegExpHttpResponseParser
implements HttpResponseParser {
    private final List<RegExpLineFormat> lineFormats;

    public RegExpHttpResponseParser(List<RegExpLineFormat> lineFormats) {
        this.lineFormats = Collections.unmodifiableList(lineFormats);
    }

    public List<RegExpLineFormat> getLineFormats() {
        return this.lineFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<MetricName, MetricValue> parse(HttpResponse response, HttpEntity entity, InputStreamReader reader) {
        HashMap<MetricName, MetricValue> result = new HashMap<MetricName, MetricValue>();
        try (LineIterator lines = new LineIterator((Reader)reader);){
            long timestamp = System.currentTimeMillis();
            while (lines.hasNext()) {
                this.parseLine(result, timestamp, lines.next());
            }
        }
        return result;
    }

    protected boolean parseLine(Map<MetricName, MetricValue> result, long timestamp, String line) {
        for (RegExpLineFormat regexp : this.lineFormats) {
            if (!regexp.parse(result, timestamp, line)) continue;
            return true;
        }
        return false;
    }
}

