/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.extensions.http.parsers.regexp;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metricssampler.reader.MetricName;
import org.metricssampler.reader.MetricValue;
import org.metricssampler.reader.SimpleMetricName;

public class RegExpLineFormat {
    private final Pattern pattern;
    private final int nameGroupIndex;
    private final int valueGroupIndex;

    public RegExpLineFormat(Pattern pattern, int nameGroupIndex, int valueGroupIndex) {
        this.pattern = pattern;
        this.nameGroupIndex = nameGroupIndex;
        this.valueGroupIndex = valueGroupIndex;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public int getNameGroupIndex() {
        return this.nameGroupIndex;
    }

    public int getValueGroupIndex() {
        return this.valueGroupIndex;
    }

    public boolean parse(Map<MetricName, MetricValue> values, long timestamp, String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.matches()) {
            String name = matcher.group(this.nameGroupIndex);
            String value = matcher.group(this.valueGroupIndex);
            values.put((MetricName)new SimpleMetricName(name, null), new MetricValue(timestamp, (Object)value));
            return true;
        }
        return false;
    }
}

