/*
 * Decompiled with CFR 0.152.
 */
package org.metricssampler.extensions.http.parsers.regexp;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.regex.Pattern;
import org.metricssampler.config.loader.xbeans.ValidationUtils;
import org.metricssampler.extensions.http.parsers.regexp.RegExpLineFormat;

@XStreamAlias(value="regexp-line-format")
public class RegExpLineFormatXBean {
    @XStreamAsAttribute
    private String expression;
    @XStreamAlias(value="name-index")
    @XStreamAsAttribute
    private int nameIndex;
    @XStreamAlias(value="value-index")
    @XStreamAsAttribute
    private int valueIndex;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int nameIndex) {
        this.nameIndex = nameIndex;
    }

    public int getValueIndex() {
        return this.valueIndex;
    }

    public void setValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    protected void validate() {
        ValidationUtils.notEmpty((Object)this, (String)"expression", (String)this.getExpression());
        ValidationUtils.validPattern((Object)this, (String)"expression", (String)this.getExpression());
        ValidationUtils.greaterThanZero((Object)this, (String)"name-index", (Integer)this.getNameIndex());
        ValidationUtils.greaterThanZero((Object)this, (String)"value-index", (Integer)this.getValueIndex());
    }

    public RegExpLineFormat createFormat() {
        this.validate();
        return new RegExpLineFormat(Pattern.compile(this.expression), this.getNameIndex(), this.getValueIndex());
    }
}

