/*
 * Decompiled with CFR 0.152.
 */
package org.erc.log4j2.layout;

import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.status.StatusLogger;
import org.erc.log4j2.layout.UserField;

@Plugin(name="JSONLog4j2Layout", category="Core", elementType="layout", printObject=true)
public class JSONLog4j2Layout
extends AbstractStringLayout {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String VERSION = "1";
    private static final String ENTITY_SEP = "\"";
    private static final String OBJ_S = "{";
    private static final String OBJ_E = "}";
    private static final String LST_S = "[";
    private static final String LST_E = "]";
    private static final String COMMA = ",";
    private static final String DOTS = ":";
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private static final DateFormat ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS;
    private boolean locationInfo = false;
    private boolean singleLine = false;
    private boolean htmlSafe = false;
    private boolean plainContextMap = false;
    private UserField[] userFields;

    protected JSONLog4j2Layout(boolean locationInfo, boolean singleLine, boolean htmlSafe, boolean plainContextMap, UserField[] userFields, Charset charset) {
        super(charset);
        this.locationInfo = locationInfo;
        this.singleLine = singleLine;
        this.plainContextMap = plainContextMap;
        this.userFields = userFields;
        ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @PluginFactory
    public static JSONLog4j2Layout createLayout(@PluginConfiguration Configuration config, @PluginAttribute(value="locationInfo") boolean locationInfo, @PluginAttribute(value="singleLine") boolean singleLine, @PluginAttribute(value="htmlSafe") boolean htmlSafe, @PluginAttribute(value="plainContextMap") boolean plainContextMap, @PluginAttribute(value="charset") Charset charset, @PluginElement(value="UserFields") UserField[] userFields) {
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        LOGGER.debug("Creating JSONLog4j2Layout {}", (Object)charset);
        return new JSONLog4j2Layout(locationInfo, singleLine, htmlSafe, plainContextMap, userFields, charset);
    }

    private String cleanJSON(String value) {
        LOGGER.debug("cleanJSON {}", (Object)value);
        if (value == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (this.singleLine) {
            value = value.replaceAll("\r", "");
            value = value.replaceAll("\n", "");
        }
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            String replacement = null;
            if (c < '\u0080') {
                String string = replacement = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS[c] : REPLACEMENT_CHARS[c];
            }
            if (replacement != null) {
                builder.append(replacement);
                continue;
            }
            if (c == '\u2028') {
                builder.append("\\u2028");
                continue;
            }
            if (c == '\u2029') {
                builder.append("\\u2029");
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String getStackTrace(StackTraceElement[] traces) {
        StringBuilder builder = new StringBuilder();
        if (traces != null) {
            for (StackTraceElement trace : traces) {
                builder.append(this.cleanJSON(trace.toString())).append("\n");
            }
        }
        return builder.toString();
    }

    private void addField(StringBuilder builder, String key, Object value) {
        this.addField(builder, key, value, true);
    }

    private String getMap(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(LST_S);
        if (map != null && !map.isEmpty()) {
            for (Object key : map.keySet()) {
                builder.append(OBJ_S);
                builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS);
                Object value = map.get(key);
                if (value != null) {
                    builder.append(ENTITY_SEP).append(this.cleanJSON(value.toString())).append(ENTITY_SEP);
                } else {
                    builder.append(ENTITY_SEP).append(ENTITY_SEP);
                }
                builder.append(OBJ_E);
                builder.append(COMMA);
            }
        }
        builder.append(OBJ_S);
        builder.append(ENTITY_SEP).append("X-Generator").append(ENTITY_SEP).append(DOTS);
        builder.append(ENTITY_SEP).append("JSONLog2j2Layout").append(ENTITY_SEP);
        builder.append(OBJ_E);
        builder.append(LST_E);
        return builder.toString();
    }

    private void addField(StringBuilder builder, String key, Object value, boolean comma) {
        LOGGER.debug("addField {}={} ({})", (Object)key, value, (Object)comma);
        if (value == null) {
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS).append(ENTITY_SEP).append(ENTITY_SEP);
        } else if (value instanceof String) {
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS);
            builder.append(ENTITY_SEP).append(this.cleanJSON(value.toString())).append(ENTITY_SEP);
        } else if (value instanceof Number) {
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS).append(value);
        } else if (value instanceof ThreadContext.ContextStack) {
            List stack = ((ThreadContext.ContextStack)value).asList();
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS);
            builder.append(LST_S);
            if (stack != null && !stack.isEmpty()) {
                for (int i = 0; i < stack.size(); ++i) {
                    builder.append(ENTITY_SEP).append(this.cleanJSON((String)stack.get(i))).append(ENTITY_SEP);
                    if (i >= stack.size() - 1) continue;
                    builder.append(COMMA);
                }
            }
            builder.append(LST_E);
        } else if (value instanceof Map) {
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS).append(this.getMap((Map)value));
        } else if (value instanceof Throwable) {
            Throwable t = (Throwable)value;
            builder.append(ENTITY_SEP).append(key).append(ENTITY_SEP).append(DOTS);
            builder.append(OBJ_S);
            this.addField(builder, "exception_class", t.getClass().getCanonicalName());
            this.addField(builder, "exception_message", this.cleanJSON(t.getMessage()));
            this.addField(builder, "stacktrace", this.getStackTrace(t.getStackTrace()), false);
            builder.append(OBJ_E);
        }
        if (comma) {
            builder.append(COMMA);
        }
    }

    private String getHostName() {
        String hostName = "unknown-host";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    private String getHostIP() {
        String hostName = "unknown-address";
        try {
            hostName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    public String toSerializable(LogEvent event) {
        StringBuilder builder = new StringBuilder();
        builder.append(OBJ_S);
        this.addField(builder, "@timestamp", ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS.format(event.getTimeMillis()));
        if (event != null) {
            this.addField(builder, "logger_name", event.getLoggerName());
            if (event.getLevel() != null) {
                this.addField(builder, "level", event.getLevel().name());
                this.addField(builder, "level_int", event.getLevel().intLevel());
            }
            this.addField(builder, "thread_name", event.getThreadName());
            this.addField(builder, "source_host", this.getHostName());
            this.addField(builder, "source_ip", this.getHostIP());
            if (event.getMessage() != null) {
                this.addField(builder, "message", event.getMessage().getFormattedMessage());
            }
            if (event.getThrown() != null) {
                this.addField(builder, "exception", event.getThrown());
            }
            if (this.locationInfo) {
                this.addField(builder, "file", event.getSource().getFileName());
                this.addField(builder, "line_number", event.getSource().getLineNumber());
                this.addField(builder, "class", event.getSource().getClassName());
                this.addField(builder, "method", event.getSource().getMethodName());
            }
            if (event.getContextStack() != null) {
                this.addField(builder, "contextStack", event.getContextStack());
            }
            if (event.getContextData() != null) {
                if (this.plainContextMap) {
                    event.getContextData().forEach((k, v) -> this.addField(builder, (String)k, v));
                } else {
                    this.addField(builder, "contextMap", event.getContextData());
                }
            }
            if (this.userFields != null) {
                for (UserField userField : this.userFields) {
                    this.addField(builder, userField.getKey(), userField.getValue());
                }
            }
        }
        this.addField(builder, "@version", VERSION, false);
        builder.append(OBJ_E);
        builder.append("\n");
        return builder.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JSONLog4j2Layout.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JSONLog4j2Layout.REPLACEMENT_CHARS[34] = "\\\"";
        JSONLog4j2Layout.REPLACEMENT_CHARS[92] = "\\\\";
        JSONLog4j2Layout.REPLACEMENT_CHARS[9] = "\\t";
        JSONLog4j2Layout.REPLACEMENT_CHARS[8] = "\\b";
        JSONLog4j2Layout.REPLACEMENT_CHARS[10] = "\\n";
        JSONLog4j2Layout.REPLACEMENT_CHARS[13] = "\\r";
        JSONLog4j2Layout.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JSONLog4j2Layout.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        JSONLog4j2Layout.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JSONLog4j2Layout.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JSONLog4j2Layout.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JSONLog4j2Layout.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
        ISO_DATETIME_TIME_ZONE_FORMAT_WITH_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }
}

