/*
 * Decompiled with CFR 0.152.
 */
package devutility.external.commons_net;

import devutility.internal.lang.StringHelper;
import devutility.internal.net.UrlUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

public class FtpHelper
implements Closeable {
    private String host;
    private int port;
    private String userName;
    private String password;
    private String startPath;
    protected FTPClient ftpClient;

    public FtpHelper(String host, int port, String userName, String password, String startPath) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.startPath = startPath;
        this.init();
    }

    private void init() {
        this.ftpClient = new FTPClient();
        if (StringHelper.isNotEmpty((String)this.startPath)) {
            this.startPath = this.startPath.trim();
            if (this.startPath.endsWith("/")) {
                this.startPath = StringHelper.trimEnd((String)this.startPath, (String)"/");
            }
            if (!this.startPath.startsWith("/")) {
                this.startPath = "/" + this.startPath;
            }
        }
    }

    public void connect() throws SocketException, IOException {
        if (this.ftpClient.isConnected()) {
            return;
        }
        this.ftpClient.connect(this.host, this.port);
        this.ftpClient.login(this.userName, this.password);
        this.ftpClient.setControlEncoding("utf-8");
        this.ftpClient.enterLocalPassiveMode();
        int replyCode = this.ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)replyCode)) {
            System.out.println(String.format("Connect to FTP server %s:%d failed.", this.host, this.port));
        } else {
            System.out.println(String.format("Connect to FTP server %s:%d successed.", this.host, this.port));
        }
    }

    public void disconnect() {
        try {
            this.ftpClient.disconnect();
            System.out.println(String.format("Disconnect FTP server %s:%d successed.", this.host, this.port));
        }
        catch (IOException e) {
            System.out.println(String.format("Disconnect FTP server %s:%d failed.", this.host, this.port));
            e.printStackTrace();
        }
    }

    @Override
    public void close() throws IOException {
        this.disconnect();
    }

    public boolean createDirecroty(String path) throws IOException {
        if (StringHelper.isNullOrEmpty((String)path)) {
            throw new IOException("Path cannot be null, create direcroty failed!");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String tailPath = path;
        if (StringHelper.isNotEmpty((String)this.startPath)) {
            if (path.indexOf(this.startPath) != 0) {
                String message = String.format("Parameter path %s must start with start path %s that you configured, create direcroty failed!", path, this.startPath);
                throw new IOException(message);
            }
            tailPath = path.substring(this.startPath.length() + 1);
        }
        String[] array = tailPath.split("/");
        String creatingDirectory = this.startPath;
        for (int i = 0; i < array.length; ++i) {
            if (this.ftpClient.changeWorkingDirectory(creatingDirectory = UrlUtils.concat((String[])new String[]{creatingDirectory, array[i]})) || this.ftpClient.makeDirectory(creatingDirectory)) continue;
            return false;
        }
        return true;
    }

    public boolean changeWorkingDirectory(String path) throws IOException {
        return this.ftpClient.changeWorkingDirectory(path);
    }

    public boolean isFileExist(String filePath) throws IOException {
        return this.ftpClient.listFiles(filePath).length > 0;
    }

    public boolean upload(InputStream inputStream, String ftpDirectoryPath, String fileName) throws SocketException, IOException {
        if (!ftpDirectoryPath.startsWith("/")) {
            ftpDirectoryPath = "/" + ftpDirectoryPath;
        }
        if (!this.createDirecroty(ftpDirectoryPath)) {
            throw new IOException("Create direcroty failed!");
        }
        if (!this.ftpClient.changeWorkingDirectory(ftpDirectoryPath)) {
            throw new IOException("Change working direcroty failed!");
        }
        this.ftpClient.setFileType(2);
        return this.ftpClient.storeFile(fileName, inputStream);
    }

    public boolean upload(String localFile, String ftpDirectoryPath, String fileName) throws IOException {
        File file = new File(localFile);
        if (!file.exists()) {
            throw new IOException("File not found!");
        }
        return this.upload(new FileInputStream(file), ftpDirectoryPath, fileName);
    }

    public boolean upload(String localFile, String ftpDirectoryPath) throws IOException {
        File file = new File(localFile);
        if (!file.exists()) {
            throw new IOException("File not found!");
        }
        return this.upload(new FileInputStream(file), ftpDirectoryPath, file.getName());
    }

    public boolean download(String ftpDirectoryPath, String fileName, OutputStream outputStream) throws IOException {
        if (!ftpDirectoryPath.startsWith("/")) {
            ftpDirectoryPath = "/" + ftpDirectoryPath;
        }
        if (!this.ftpClient.changeWorkingDirectory(ftpDirectoryPath)) {
            return false;
        }
        return this.ftpClient.retrieveFile(fileName, outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean download(String ftpDirectoryPath, String fileName, String localFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(localFile);){
            boolean bl = this.download(ftpDirectoryPath, fileName, outputStream);
            return bl;
        }
    }

    public boolean remove(String ftpDirectoryPath, String fileName) throws IOException {
        if (!ftpDirectoryPath.startsWith("/")) {
            ftpDirectoryPath = "/" + ftpDirectoryPath;
        }
        if (!this.ftpClient.changeWorkingDirectory(ftpDirectoryPath)) {
            throw new IOException("Change working direcroty failed!");
        }
        return this.ftpClient.deleteFile(fileName);
    }
}

