/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.ebfhub.fastprotobuf.FastProtoMessage;

public class FastProtoObjectPool {
    private Map<Class<?>, PoolInstance> pool = new HashMap();
    private PoolInstance stringBuilderPool = new PoolInstance(StringBuilder::new);
    private PoolInstance arrayListPool = new PoolInstance(ArrayList::new);

    public FastProtoObjectPool() {
        this.pool.put(StringBuilder.class, this.stringBuilderPool);
        this.pool.put(ArrayList.class, this.arrayListPool);
    }

    public void returnOne(Object o) {
        this.clear(o);
        Class<?> cl = o.getClass();
        PoolInstance l = this.getPoolInstance(cl);
        l.add(o);
    }

    public void returnSpecific(StringBuilder o) {
        o.setLength(0);
        this.stringBuilderPool.add(o);
    }

    public void returnSpecific(FastProtoMessage o) {
        o.clear();
        Class<?> cl = o.getClass();
        PoolInstance l = this.getPoolInstance(cl);
        l.add(o);
    }

    private PoolInstance getPoolInstance(Class<?> cl) {
        PoolInstance l = this.pool.get(cl);
        if (l == null) {
            l = new PoolInstance(cl);
            this.pool.put(cl, l);
        }
        return l;
    }

    public void returnSpecific(List<?> o) {
        this.clearList(o);
        this.arrayListPool.add(o);
    }

    public void returnSpecific(TIntArrayList o) {
        o.clear();
        this.arrayListPool.add(o);
    }

    private void clear(Object o) {
        if (o instanceof FastProtoMessage) {
            ((FastProtoMessage)o).clear();
        } else if (o instanceof List) {
            this.clearList((List)o);
        } else if (o instanceof TIntArrayList) {
            ((TIntArrayList)o).clear();
        } else {
            ((StringBuilder)o).setLength(0);
        }
    }

    public void clearList(List<?> list) {
        int size = list.size();
        for (int n = 0; n < size; ++n) {
            this.returnOne(list.get(n));
        }
        list.clear();
    }

    public <T> T take(Class<T> cl) {
        PoolInstance l = this.getPoolInstance(cl);
        return (T)l.take();
    }

    public <T> ArrayList<T> takeList() {
        return this.take(ArrayList.class);
    }

    public TIntArrayList takeIntList() {
        return this.take(TIntArrayList.class);
    }

    private class PoolInstance {
        List<Object> instances = new ArrayList<Object>();
        Supplier<Object> creator;

        void add(Object o) {
            this.instances.add(o);
        }

        PoolInstance(Supplier<Object> s) {
            this.creator = s;
        }

        PoolInstance(Class cl) {
            if (cl == StringBuilder.class) {
                this.creator = StringBuffer::new;
            } else if (cl == ArrayList.class) {
                this.creator = ArrayList::new;
            } else {
                try {
                    Method method = cl.getMethod("create", FastProtoObjectPool.class);
                    this.creator = () -> {
                        try {
                            return method.invoke(null, FastProtoObjectPool.this);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public int size() {
            return this.instances.size();
        }

        Object take() {
            if (this.instances.size() == 0) {
                return this.creator.get();
            }
            return this.instances.remove(this.instances.size() - 1);
        }
    }
}

