/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import org.ebfhub.fastprotobuf.FastProtoField;
import org.ebfhub.fastprotobuf.FastProtoMessage;
import org.ebfhub.fastprotobuf.FastProtoObjectPool;
import org.ebfhub.fastprotobuf.FastProtoSetter;
import org.ebfhub.fastprotobuf.MutableByteArrayInputStream;
import org.ebfhub.fastprotobuf.Utf8;

public class FastProtoReader {
    private byte[] bb = new byte[0];
    FastProtoObjectPool pool = new FastProtoObjectPool();
    Utf8.ByteProvider provider = new Utf8.ByteProvider(){

        @Override
        byte getByte(Object src, long offset) {
            return ((byte[])src)[(int)offset];
        }
    };
    MutableByteArrayInputStream mis = new MutableByteArrayInputStream();
    CodedInputStream is3 = CodedInputStream.newInstance((InputStream)this.mis);

    public FastProtoObjectPool getPool() {
        return this.pool;
    }

    public void parse(CodedInputStream is, FastProtoSetter setter) throws IOException {
        while (!is.isAtEnd()) {
            int tag = is.readTag();
            int wt = WireFormat.getTagWireType((int)tag);
            int field = WireFormat.getTagFieldNumber((int)tag);
            FastProtoField fd = setter.field_getDef(field);
            WireFormat.FieldType lt = fd.ft;
            block0 : switch (wt) {
                case 0: {
                    switch (lt) {
                        case INT32: {
                            setter.field_set(field, is.readInt32());
                            break block0;
                        }
                        case INT64: {
                            setter.field_set(field, is.readInt64());
                            break block0;
                        }
                        case SINT32: {
                            setter.field_set(field, is.readSInt32());
                            break block0;
                        }
                        case SINT64: {
                            setter.field_set(field, is.readSInt64());
                            break block0;
                        }
                        case UINT32: {
                            setter.field_set(field, is.readUInt32());
                            break block0;
                        }
                        case UINT64: {
                            setter.field_set(field, is.readUInt64());
                            break block0;
                        }
                        case FIXED32: {
                            setter.field_set(field, is.readFixed32());
                            break block0;
                        }
                        case FIXED64: {
                            setter.field_set(field, is.readFixed64());
                            break block0;
                        }
                        case SFIXED32: {
                            setter.field_set(field, is.readSFixed32());
                            break block0;
                        }
                        case SFIXED64: {
                            setter.field_set(field, is.readSFixed64());
                            break block0;
                        }
                        case BOOL: {
                            setter.field_set(field, is.readBool());
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("unknown type " + lt + ":" + fd.name);
                }
                case 5: {
                    switch (lt) {
                        case FLOAT: {
                            setter.field_set(field, is.readFloat());
                            break block0;
                        }
                        case SFIXED32: {
                            setter.field_set(field, is.readSFixed32());
                            break block0;
                        }
                        case FIXED32: {
                            setter.field_set(field, is.readFixed32());
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("unknown type " + lt + ":" + fd.name);
                }
                case 1: {
                    switch (lt) {
                        case DOUBLE: {
                            setter.field_set(field, is.readDouble());
                            break block0;
                        }
                        case SFIXED64: {
                            setter.field_set(field, is.readSFixed64());
                            break block0;
                        }
                        case FIXED64: {
                            setter.field_set(field, is.readFixed64());
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("unknown type " + lt + ":" + fd.name);
                }
                case 2: {
                    int size = is.readRawVarint32();
                    if (size < 0) {
                        throw new IllegalStateException();
                    }
                    switch (lt) {
                        case STRING: {
                            if (this.bb.length < size) {
                                this.bb = new byte[size];
                            }
                            for (int n = 0; n < size; ++n) {
                                byte b;
                                this.bb[n] = b = is.readRawByte();
                            }
                            if (fd.repeated) {
                                StringBuilder sb = setter.field_add_builder(field);
                                sb.setLength(0);
                                Utf8.getCharsFromUtf8(0L, size, sb, 0L, this.bb, this.provider);
                                break block0;
                            }
                            StringBuilder sb = setter.field_builder(field);
                            sb.setLength(0);
                            Utf8.getCharsFromUtf8(0L, size, sb, 0L, this.bb, this.provider);
                            break block0;
                        }
                        case MESSAGE: {
                            int l = is.pushLimit(size);
                            this.parse(is, setter.field_add(field).getSetter());
                            is.popLimit(l);
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public void readItem(FastProtoMessage val, byte[] b, int offset, int len) throws IOException {
        val.clear();
        this.mis.setBytes(b, offset, len);
        this.parse(this.is3, val.getSetter());
        this.is3.resetSizeCounter();
    }

    public void readItem(FastProtoMessage val, CodedInputStream is3) throws IOException {
        val.clear();
        this.parse(is3, val.getSetter());
    }
}

