/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import java.util.Stack;

class JavaOutput {
    private StringBuilder sb = new StringBuilder();
    private Stack<IndentType> indent = new Stack();

    JavaOutput() {
    }

    private IndentType peek() {
        return this.indent.size() == 0 ? null : this.indent.peek();
    }

    private void push(IndentType t) {
        this.indent.push(t);
    }

    private void pop(IndentType t) {
        if (this.indent.size() == 0) {
            this.sb.append("\n//pop expected " + (Object)((Object)t) + " not empty\n");
            return;
        }
        IndentType k = this.indent.pop();
        if (k != t) {
            this.sb.append("\n//pop expected " + (Object)((Object)t) + " not " + (Object)((Object)k) + "\n");
        }
    }

    void line(String l) {
        if (l.contains("}") && !l.contains("{")) {
            this.pop(IndentType.BRACE);
        }
        for (int n = 0; n < this.indent.size(); ++n) {
            this.sb.append("    ");
        }
        this.sb.append(l.trim());
        this.sb.append("\n");
        if (l.contains("{") && !l.contains("}")) {
            this.push(IndentType.BRACE);
        }
        if (l.contains("case ") || l.contains("default:")) {
            this.push(IndentType.CASE);
        }
        if (this.peek() == IndentType.CASE && (l.contains("return") || l.contains("throw"))) {
            this.pop(IndentType.CASE);
        }
        if (l.contains("break;")) {
            this.pop(IndentType.CASE);
        }
    }

    void imports(Class<?> ... cls) {
        for (Class<?> cl : cls) {
            this.line("import " + cl.getName() + ";");
        }
    }

    public String toString() {
        return this.sb.toString();
    }

    public void blank() {
        this.sb.append("\n");
    }

    static enum IndentType {
        BRACE,
        CASE;

    }
}

