/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.ebfhub.fastprotobuf.FastProtoField;
import org.ebfhub.fastprotobuf.FastProtoMessage;
import org.ebfhub.fastprotobuf.FastProtoObjectPool;
import org.ebfhub.fastprotobuf.FastProtoReader;
import org.ebfhub.fastprotobuf.FastProtoWritable;
import org.ebfhub.fastprotobuf.FastProtoWriter;
import org.ebfhub.fastprotobuf.Utf8;

public abstract class FastProtoMessageBase<T extends FastProtoMessage>
implements FastProtoMessage,
FastProtoWritable,
Message {
    protected int fieldsSet = 0;
    protected FastProtoObjectPool pool;
    private int refCount = 1;
    protected static ThreadLocal<FastProtoReader> DEFAULT_PARSER = ThreadLocal.withInitial(FastProtoReader::new);
    protected static ThreadLocal<FastProtoWriter> DEFAULT_WRITER = ThreadLocal.withInitial(FastProtoWriter::new);

    protected static FastProtoReader getDefaultReader() {
        return DEFAULT_PARSER.get();
    }

    protected static FastProtoWriter getDefaultWriter() {
        return DEFAULT_WRITER.get();
    }

    protected FastProtoMessageBase() {
    }

    protected FastProtoMessageBase(FastProtoObjectPool pool) {
        this.pool = pool;
    }

    public T retain() {
        if (this.refCount <= 0) {
            throw new UnsupportedOperationException("Unexpected ref count<1 " + this.refCount);
        }
        ++this.refCount;
        return (T)this;
    }

    @Override
    public void release() {
        if (this.refCount <= 0) {
            throw new UnsupportedOperationException("Unexpected ref count<1 " + this.refCount);
        }
        if (--this.refCount == 0) {
            this.pool.returnSpecific(this);
        }
    }

    @Override
    public void setRefCount(int i) {
        this.refCount = i;
    }

    protected static FastProtoObjectPool getDefaultPool() {
        return FastProtoMessageBase.getDefaultReader().getPool();
    }

    public boolean isSet(FastProtoField f) {
        return (this.fieldsSet & f.bit) != 0;
    }

    public void writeTo(CodedOutputStream codedOutputStream) throws IOException {
        FastProtoWriter writer = FastProtoMessageBase.getDefaultWriter();
        this.write(codedOutputStream, writer);
    }

    public static int computeStringSizeNoTag(CharSequence value) {
        int length = Utf8.encodedLength(value);
        return FastProtoMessageBase.computeLengthDelimitedFieldSize(length);
    }

    public static int computeStringSize(int fieldNumber, CharSequence value) {
        return CodedOutputStream.computeTagSize((int)fieldNumber) + FastProtoMessageBase.computeStringSizeNoTag(value);
    }

    public static int computeMessageSize(int fieldNumber, FastProtoMessageBase<?> value) {
        return CodedOutputStream.computeTagSize((int)fieldNumber) + FastProtoMessageBase.computeLengthDelimitedFieldSize(value.getSerializedSize());
    }

    static int computeLengthDelimitedFieldSize(int fieldLength) {
        return CodedOutputStream.computeUInt32SizeNoTag((int)fieldLength) + fieldLength;
    }

    public FastProtoObjectPool getPool() {
        return this.pool;
    }

    public abstract int getSerializedSize();

    public Parser<? extends Message> getParserForType() {
        throw new UnsupportedOperationException();
    }

    public ByteString toByteString() {
        throw new UnsupportedOperationException();
    }

    public byte[] toByteArray() {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        FastProtoMessageBase.getDefaultWriter().write(outputStream, this);
    }

    public void writeDelimitedTo(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public Message.Builder newBuilderForType() {
        throw new UnsupportedOperationException();
    }

    public Message.Builder toBuilder() {
        throw new UnsupportedOperationException();
    }

    public Message getDefaultInstanceForType() {
        throw new UnsupportedOperationException();
    }

    public List<String> findInitializationErrors() {
        throw new UnsupportedOperationException();
    }

    public String getInitializationErrorString() {
        throw new UnsupportedOperationException();
    }

    public Descriptors.Descriptor getDescriptorForType() {
        throw new UnsupportedOperationException();
    }

    public Map<Descriptors.FieldDescriptor, Object> getAllFields() {
        throw new UnsupportedOperationException();
    }

    public boolean hasOneof(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException();
    }

    public Descriptors.FieldDescriptor getOneofFieldDescriptor(Descriptors.OneofDescriptor oneofDescriptor) {
        throw new UnsupportedOperationException();
    }

    public boolean hasField(Descriptors.FieldDescriptor fieldDescriptor) {
        throw new UnsupportedOperationException();
    }

    public Object getField(Descriptors.FieldDescriptor fieldDescriptor) {
        throw new UnsupportedOperationException();
    }

    public int getRepeatedFieldCount(Descriptors.FieldDescriptor fieldDescriptor) {
        throw new UnsupportedOperationException();
    }

    public Object getRepeatedField(Descriptors.FieldDescriptor fieldDescriptor, int i) {
        throw new UnsupportedOperationException();
    }

    public UnknownFieldSet getUnknownFields() {
        throw new UnsupportedOperationException();
    }

    public boolean isInitialized() {
        return true;
    }
}

