/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import gnu.trove.list.array.TIntArrayList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ebfhub.fastprotobuf.FastProtoMessage;
import org.ebfhub.fastprotobuf.FastProtoMessageBase;
import org.ebfhub.fastprotobuf.FastProtoWritable;

public class FastProtoObjectPool {
    private Map<Class<?>, PoolInstance> pool = new ConcurrentHashMap();
    private PoolInstance stringBuilderPool = new PoolInstance(StringBuilder::new);
    private PoolInstance arrayListPool = new PoolInstance(ArrayList::new);
    private static final int MAX_INSTANCES = Integer.getInteger("PROTOBUF_POOL_MAX_INSTANCES", 1024);
    private static final int DEF_CAPACITY = Integer.getInteger("PROTOBUF_POOL_DEF_CAPACITY", 1024);

    public FastProtoObjectPool() {
        this.pool.put(StringBuilder.class, this.stringBuilderPool);
        this.pool.put(ArrayList.class, this.arrayListPool);
    }

    public String toString() {
        return System.identityHashCode(this) + ":" + this.pool.toString();
    }

    private void returnOne(Object o) {
        this.clear(o);
        Class<?> cl = o.getClass();
        PoolInstance l = this.getPoolInstance(cl);
        l.add(o);
    }

    public void returnSpecific(StringBuilder o) {
        o.setLength(0);
        this.stringBuilderPool.add(o);
    }

    public void returnSpecific(FastProtoMessage o) {
        this.clearFastProtoMessage(o);
        Class<?> cl = o.getClass();
        PoolInstance l = this.getPoolInstance(cl);
        l.add(o);
    }

    private void clearFastProtoMessage(FastProtoMessage o) {
        o.clear();
        o.setRefCount(-100);
    }

    public void returnMessageList(List<? extends FastProtoMessage> o) {
        this.clearList(o);
        this.arrayListPool.add(o);
    }

    public void returnSpecific(List<?> o) {
        this.clearList(o);
        this.arrayListPool.add(o);
    }

    public void returnSpecific(TIntArrayList o) {
        o.clear();
        this.arrayListPool.add(o);
    }

    private PoolInstance getPoolInstance(Class<?> cl) {
        PoolInstance l = this.pool.get(cl);
        if (l == null) {
            l = this.pool.computeIfAbsent(cl, x$0 -> new PoolInstance((Class)x$0));
        }
        return l;
    }

    private void clear(Object o) {
        if (o instanceof FastProtoMessage) {
            this.clearFastProtoMessage((FastProtoMessage)o);
        } else if (o instanceof List) {
            this.clearList((List)o);
        } else if (o instanceof TIntArrayList) {
            ((TIntArrayList)o).clear();
        } else {
            ((StringBuilder)o).setLength(0);
        }
    }

    private void clearList(List<?> list) {
        int size = list.size();
        for (int n = 0; n < size; ++n) {
            Object o = list.get(n);
            if (o instanceof FastProtoWritable) {
                ((FastProtoWritable)o).release();
                continue;
            }
            this.returnOne(o);
        }
        list.clear();
    }

    public <T> T take(Class<T> cl) {
        PoolInstance l = this.getPoolInstance(cl);
        return (T)l.take();
    }

    public <T> ArrayList<T> takeList() {
        return this.take(ArrayList.class);
    }

    public TIntArrayList takeIntList() {
        return this.take(TIntArrayList.class);
    }

    static /* synthetic */ int access$000() {
        return DEF_CAPACITY;
    }

    private class PoolInstance {
        final List<Object> instances = new ArrayList<Object>(FastProtoObjectPool.access$000());
        Supplier<Object> creator;
        Consumer<Object> cleaner;

        PoolInstance(Supplier<Object> s) {
            this.creator = s;
            this.cleaner = a -> {};
        }

        PoolInstance(Class cl) {
            if (cl == StringBuilder.class) {
                this.creator = StringBuffer::new;
                this.cleaner = a -> {};
            } else if (cl == ArrayList.class) {
                this.creator = ArrayList::new;
                this.cleaner = a -> {};
            } else {
                try {
                    Method method = cl.getMethod("create", FastProtoObjectPool.class);
                    this.creator = () -> {
                        try {
                            return method.invoke(null, FastProtoObjectPool.this);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
                this.cleaner = a -> ((FastProtoMessageBase)a).setRefCount(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Object o) {
            List<Object> list = this.instances;
            synchronized (list) {
                if (this.instances.size() < MAX_INSTANCES) {
                    this.instances.add(o);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            List<Object> list = this.instances;
            synchronized (list) {
                return this.instances.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            List<Object> list = this.instances;
            synchronized (list) {
                return String.valueOf(this.instances.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object take() {
            List<Object> list = this.instances;
            synchronized (list) {
                int size = this.instances.size();
                if (size != 0) {
                    Object inst = this.instances.remove(size - 1);
                    this.cleaner.accept(inst);
                    return inst;
                }
            }
            return this.creator.get();
        }
    }
}

