/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.ebfhub.fastprotobuf.FastProtoWritable;
import org.ebfhub.fastprotobuf.ReusableByteArrayOutputStream;
import org.ebfhub.fastprotobuf.Utf8;

public class FastProtoWriter {
    private byte[] buf = new byte[1024];
    final Utf8.ByteWriter writer = new Utf8.ByteWriter(){

        @Override
        void putByte(Object src, long offset, byte b) {
            if (offset == (long)FastProtoWriter.this.buf.length) {
                byte[] buf2 = new byte[FastProtoWriter.this.buf.length * 2];
                System.arraycopy(FastProtoWriter.this.buf, 0, buf2, 0, FastProtoWriter.this.buf.length);
                FastProtoWriter.access$002(FastProtoWriter.this, buf2);
            }
            ((FastProtoWriter)FastProtoWriter.this).buf[(int)offset] = b;
        }
    };
    private List<Helper> pool = new ArrayList<Helper>();

    public int getStringBufferLen() {
        return this.buf.length;
    }

    public void setStringBuffer(byte[] b) {
        this.buf = b;
    }

    public void writeString(int field, CodedOutputStream os, CharSequence str) throws IOException {
        long len = Utf8.putCharsToUtf8(0L, str, Integer.MAX_VALUE, 0L, this.buf, this.writer);
        os.writeTag(field, 2);
        os.writeUInt32NoTag((int)len);
        os.writeLazy(this.buf, 0, (int)len);
    }

    public void writeMessage(int field, CodedOutputStream os, int i) throws IOException {
        os.writeInt32(field, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMessage(int field, CodedOutputStream os, FastProtoWritable w) throws IOException {
        Helper h = this.pool.size() == 0 ? new Helper() : this.pool.remove(this.pool.size() - 1);
        try {
            h.bos.reset();
            w.write(h.os, this);
            h.os.flush();
            int bytes = h.bos.size();
            os.writeTag(field, 2);
            os.writeUInt32NoTag(bytes);
            os.writeLazy(h.bos.getBytes(), 0, bytes);
        }
        finally {
            this.pool.add(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream, FastProtoWritable w) throws IOException {
        Helper h = this.pool.size() == 0 ? new Helper() : this.pool.remove(this.pool.size() - 1);
        try {
            CodedOutputStream os = h.set(outputStream);
            w.write(os, this);
            os.flush();
        }
        finally {
            h.reset();
            this.pool.add(h);
        }
    }

    static /* synthetic */ byte[] access$002(FastProtoWriter x0, byte[] x1) {
        x0.buf = x1;
        return x1;
    }

    private static class Helper {
        ReusableByteArrayOutputStream bos = new ReusableByteArrayOutputStream();
        MutableOutputStream mos = new MutableOutputStream(this.bos);
        CodedOutputStream os = CodedOutputStream.newInstance((OutputStream)this.mos);

        private Helper() {
        }

        public void reset() {
            this.mos.nested = this.bos;
            this.bos.reset();
        }

        CodedOutputStream set(OutputStream outputStream) {
            this.mos.nested = outputStream;
            return this.os;
        }
    }

    private static class MutableOutputStream
    extends OutputStream {
        OutputStream nested;

        public MutableOutputStream(ReusableByteArrayOutputStream bos) {
            this.nested = bos;
        }

        @Override
        public void write(int b) throws IOException {
            this.nested.write(b);
        }
    }
}

