/*
 * Decompiled with CFR 0.152.
 */
package org.ebfhub.fastprotobuf;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ProtoDebug {
    static String INDENT = "   ";

    public static String decodeProto(byte[] data, boolean singleLine) throws IOException {
        return ProtoDebug.decodeProto(ByteString.copyFrom((byte[])data), 0, singleLine);
    }

    public static String decodeProto(ByteString data, int depth, boolean singleLine) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((ByteBuffer)data.asReadOnlyByteBuffer());
        return ProtoDebug.decodeProtoInput(input, depth, singleLine);
    }

    private static String decodeProtoInput(CodedInputStream input, int depth, boolean singleLine) throws IOException {
        boolean foundFields;
        StringBuilder s;
        block14: {
            s = new StringBuilder("{ ");
            foundFields = false;
            block9: while (true) {
                int tag = input.readTag();
                int type = WireFormat.getTagWireType((int)tag);
                if (tag == 0 || type == 4) break block14;
                foundFields = true;
                ProtoDebug.protoNewline(depth, s, singleLine);
                int number = WireFormat.getTagFieldNumber((int)tag);
                s.append(number).append(": ");
                switch (type) {
                    case 0: {
                        s.append(input.readInt64());
                        continue block9;
                    }
                    case 1: {
                        s.append(Double.longBitsToDouble(input.readFixed64()));
                        continue block9;
                    }
                    case 2: {
                        ByteString data = input.readBytes();
                        try {
                            String submessage = ProtoDebug.decodeProto(data, depth + 1, singleLine);
                            if (data.size() < 30) {
                                boolean probablyString = true;
                                String str = new String(data.toByteArray(), Charsets.UTF_8);
                                for (char c : str.toCharArray()) {
                                    if (c >= '\n') continue;
                                    probablyString = false;
                                    break;
                                }
                                if (probablyString) {
                                    s.append("\"").append(str).append("\" ");
                                }
                            }
                            s.append(submessage);
                        }
                        catch (IOException e) {
                            s.append('\"').append(new String(data.toByteArray())).append('\"');
                        }
                        continue block9;
                    }
                    case 3: {
                        s.append(ProtoDebug.decodeProtoInput(input, depth + 1, singleLine));
                        continue block9;
                    }
                    case 5: {
                        s.append(Float.intBitsToFloat(input.readFixed32()));
                        continue block9;
                    }
                }
                break;
            }
            throw new InvalidProtocolBufferException("Invalid wire type");
        }
        if (foundFields) {
            ProtoDebug.protoNewline(depth - 1, s, singleLine);
        }
        return s.append('}').toString();
    }

    private static void protoNewline(int depth, StringBuilder s, boolean noNewline) {
        if (noNewline) {
            s.append(" ");
            return;
        }
        s.append('\n');
        for (int i = 0; i <= depth; ++i) {
            s.append(INDENT);
        }
    }
}

