/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload;

import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;

public class PartOutput {
    private final Object value;

    protected PartOutput(Object value) {
        this.value = value;
    }

    public <T> boolean safeToCast(Class<T> clazz) {
        return this.value != null && clazz.isAssignableFrom(this.value.getClass());
    }

    public <T> T unwrap(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    public static PartOutput from(WritableByteChannel byteChannel) {
        return new PartOutput(byteChannel);
    }

    public static PartOutput from(OutputStream outputStream) {
        return new PartOutput(outputStream);
    }

    public static PartOutput from(Path path) {
        return new PartOutput(path);
    }
}

