/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload;

import com.github.elopteryx.upload.OnError;
import com.github.elopteryx.upload.OnPartBegin;
import com.github.elopteryx.upload.OnPartEnd;
import com.github.elopteryx.upload.OnRequestComplete;
import com.github.elopteryx.upload.UploadContext;
import com.github.elopteryx.upload.internal.AbstractUploadParser;
import com.github.elopteryx.upload.internal.AsyncUploadParser;
import com.github.elopteryx.upload.internal.BlockingUploadParser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Locale;

public final class UploadParser {
    private static final int DEFAULT_USED_MEMORY = 4096;
    private static final String MULTIPART = "multipart/";
    private OnPartBegin partBeginCallback;
    private OnPartEnd partEndCallback;
    private OnRequestComplete requestCallback;
    private OnError errorCallback;
    private Object userObject;
    private int maxBytesUsed = 4096;
    private int sizeThreshold;
    private long maxPartSize = -1L;
    private long maxRequestSize = -1L;

    private UploadParser() {
    }

    public UploadParser onPartBegin(OnPartBegin partBeginCallback) {
        this.partBeginCallback = partBeginCallback;
        return this;
    }

    public UploadParser onPartEnd(OnPartEnd partEndCallback) {
        this.partEndCallback = partEndCallback;
        return this;
    }

    public UploadParser onRequestComplete(OnRequestComplete requestCallback) {
        this.requestCallback = requestCallback;
        return this;
    }

    public UploadParser onError(OnError errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    public UploadParser userObject(Object userObject) {
        this.userObject = userObject;
        return this;
    }

    public UploadParser maxBytesUsed(int maxBytesUsed) {
        if (maxBytesUsed < 2) {
            throw new IllegalArgumentException("The parameter value is too low, the parsing cannot work!");
        }
        this.maxBytesUsed = maxBytesUsed;
        return this;
    }

    public UploadParser sizeThreshold(int sizeThreshold) {
        if (sizeThreshold < 0) {
            throw new IllegalArgumentException("Invalid parameter value: " + sizeThreshold);
        }
        this.sizeThreshold = Math.max(sizeThreshold, 0);
        return this;
    }

    public UploadParser maxPartSize(long maxPartSize) {
        if (maxPartSize < 0L) {
            throw new IllegalArgumentException("Invalid parameter value: " + maxPartSize);
        }
        this.maxPartSize = maxPartSize;
        return this;
    }

    public UploadParser maxRequestSize(long maxRequestSize) {
        if (maxRequestSize < 0L) {
            throw new IllegalArgumentException("Invalid parameter value: " + maxRequestSize);
        }
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public void setupAsyncParse(HttpServletRequest request) throws IOException, ServletException {
        if (!UploadParser.isMultipart(request)) {
            throw new IllegalArgumentException("Not a multipart request!");
        }
        AsyncUploadParser parser = new AsyncUploadParser(request);
        this.build(parser);
        parser.setupAsyncParse();
    }

    public UploadContext doBlockingParse(HttpServletRequest request) throws IOException, ServletException {
        if (!UploadParser.isMultipart(request)) {
            throw new IllegalArgumentException("Not a multipart request!");
        }
        BlockingUploadParser parser = new BlockingUploadParser(request);
        this.build(parser);
        return parser.doBlockingParse();
    }

    private void build(AbstractUploadParser parser) {
        parser.setPartBeginCallback(this.partBeginCallback);
        parser.setPartEndCallback(this.partEndCallback);
        parser.setRequestCallback(this.requestCallback);
        parser.setErrorCallback(this.errorCallback);
        parser.setUserObject(this.userObject);
        parser.setMaxBytesUsed(this.maxBytesUsed);
        parser.setSizeThreshold(this.sizeThreshold);
        parser.setMaxPartSize(this.maxPartSize);
        parser.setMaxRequestSize(this.maxRequestSize);
    }

    public static boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public static UploadParser newParser() {
        return new UploadParser();
    }
}

