/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.OnError;
import com.github.elopteryx.upload.OnPartBegin;
import com.github.elopteryx.upload.OnPartEnd;
import com.github.elopteryx.upload.OnRequestComplete;
import com.github.elopteryx.upload.PartOutput;
import com.github.elopteryx.upload.errors.PartSizeException;
import com.github.elopteryx.upload.errors.RequestSizeException;
import com.github.elopteryx.upload.internal.Headers;
import com.github.elopteryx.upload.internal.MultipartParser;
import com.github.elopteryx.upload.internal.PartStreamImpl;
import com.github.elopteryx.upload.internal.UploadContextImpl;
import com.github.elopteryx.upload.util.NullChannel;
import com.github.elopteryx.upload.util.OutputStreamBackedChannel;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractUploadParser
implements MultipartParser.PartHandler {
    private static final int DEFAULT_USED_MEMORY = 4096;
    private OnPartBegin partBeginCallback;
    private OnPartEnd partEndCallback;
    OnRequestComplete requestCallback;
    OnError errorCallback;
    private Object userObject;
    protected int maxBytesUsed = 4096;
    protected int sizeThreshold;
    private long maxPartSize = -1L;
    protected long maxRequestSize = -1L;
    protected static final String MULTIPART_FORM_DATA = "multipart/form-data";
    protected ByteBuffer checkBuffer;
    private WritableByteChannel writableChannel;
    protected long requestSize;
    protected UploadContextImpl context;
    protected MultipartParser.ParseState parseState;
    protected ByteBuffer dataBuffer;

    void init(HttpServletRequest request) {
        long requestSize;
        if (this.maxRequestSize > -1L && (requestSize = request.getContentLengthLong()) > this.maxRequestSize) {
            throw new RequestSizeException("The size of the request (" + requestSize + ") is greater than the allowed size (" + this.maxRequestSize + ")!", requestSize, this.maxRequestSize);
        }
        this.checkBuffer = ByteBuffer.allocate(this.sizeThreshold);
        this.context = new UploadContextImpl(request, this.userObject);
        String mimeType = request.getHeader("Content-Type");
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = Headers.extractBoundaryFromHeader(mimeType);
            if (boundary == null) {
                throw new IllegalArgumentException("Could not find boundary in multipart request with ContentType: " + mimeType + ", multipart data will not be available");
            }
            String encodingHeader = request.getCharacterEncoding();
            Charset charset = encodingHeader == null ? StandardCharsets.ISO_8859_1 : Charset.forName(encodingHeader);
            this.parseState = MultipartParser.beginParse(this, boundary.getBytes(charset), this.maxBytesUsed, charset);
        }
    }

    void checkPartSize(int additional) {
        long partSize = this.context.incrementAndGetPartBytesRead(additional);
        if (this.maxPartSize > -1L && partSize > this.maxPartSize) {
            throw new PartSizeException("The size of the part (" + partSize + ") is greater than the allowed size (" + this.maxPartSize + ")!", partSize, this.maxPartSize);
        }
    }

    void checkRequestSize(int additional) {
        this.requestSize += (long)additional;
        if (this.maxRequestSize > -1L && this.requestSize > this.maxRequestSize) {
            throw new RequestSizeException("The size of the request (" + this.requestSize + ") is greater than the allowed size (" + this.maxRequestSize + ")!", this.requestSize, this.maxRequestSize);
        }
    }

    @Override
    public void beginPart(Headers headers) {
        String disposition = headers.getHeader("Content-Disposition");
        if (disposition != null && disposition.startsWith("form-data")) {
            String fieldName = Headers.extractQuotedValueFromHeader(disposition, "name");
            String fileName = Headers.extractQuotedValueFromHeader(disposition, "filename");
            this.context.reset(new PartStreamImpl(fileName, fieldName, headers));
        }
    }

    @Override
    public void data(ByteBuffer buffer) throws IOException {
        this.checkPartSize(buffer.remaining());
        this.copyBuffer(buffer);
        if (this.context.isBuffering() && this.context.getPartBytesRead() >= this.sizeThreshold) {
            this.validate(false);
        }
        if (!this.context.isBuffering()) {
            while (buffer.hasRemaining()) {
                this.writableChannel.write(buffer);
            }
        }
    }

    private void copyBuffer(ByteBuffer buffer) {
        int transferCount = Math.min(this.checkBuffer.remaining(), buffer.remaining());
        if (transferCount > 0) {
            this.checkBuffer.put(buffer.array(), buffer.arrayOffset() + buffer.position(), transferCount);
            buffer.position(buffer.position() + transferCount);
        }
    }

    private void validate(boolean partFinished) throws IOException {
        this.context.finishBuffering();
        if (partFinished) {
            this.context.getCurrentPart().markAsFinished();
        }
        PartOutput output = null;
        this.checkBuffer.flip();
        if (this.partBeginCallback != null) {
            output = Objects.requireNonNull(this.partBeginCallback.onPartBegin(this.context, this.checkBuffer));
            if (output.safeToCast(WritableByteChannel.class)) {
                this.writableChannel = output.unwrap(WritableByteChannel.class);
            } else if (output.safeToCast(OutputStream.class)) {
                this.writableChannel = new OutputStreamBackedChannel(output.unwrap(OutputStream.class));
            } else if (output.safeToCast(Path.class)) {
                this.writableChannel = Files.newByteChannel(output.unwrap(Path.class), EnumSet.of(StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE), new FileAttribute[0]);
            } else {
                throw new IllegalArgumentException("Invalid output object!");
            }
        }
        if (output == null) {
            this.writableChannel = new NullChannel();
            output = PartOutput.from(this.writableChannel);
        }
        this.context.setOutput(output);
        this.checkBuffer.flip();
        while (this.checkBuffer.hasRemaining()) {
            this.writableChannel.write(this.checkBuffer);
        }
    }

    @Override
    public void endPart() throws IOException {
        if (this.context.isBuffering()) {
            this.validate(true);
        }
        this.context.getCurrentPart().markAsFinished();
        this.checkBuffer.clear();
        this.context.updatePartBytesRead();
        this.writableChannel.close();
        if (this.partEndCallback != null) {
            this.partEndCallback.onPartEnd(this.context);
        }
    }

    public void setPartBeginCallback(OnPartBegin partBeginCallback) {
        this.partBeginCallback = partBeginCallback;
    }

    public void setPartEndCallback(OnPartEnd partEndCallback) {
        this.partEndCallback = partEndCallback;
    }

    public void setRequestCallback(OnRequestComplete requestCallback) {
        this.requestCallback = requestCallback;
    }

    public void setErrorCallback(OnError errorCallback) {
        this.errorCallback = errorCallback;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setMaxBytesUsed(int maxBytesUsed) {
        this.maxBytesUsed = maxBytesUsed / 2;
        this.dataBuffer = ByteBuffer.allocate(maxBytesUsed / 2);
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public void setMaxPartSize(long maxPartSize) {
        this.maxPartSize = maxPartSize;
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }
}

