/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.errors.MultipartException;
import com.github.elopteryx.upload.internal.AbstractUploadParser;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

public final class AsyncUploadParser
extends AbstractUploadParser
implements ReadListener {
    private final HttpServletRequest request;
    private ServletInputStream servletInputStream;

    public AsyncUploadParser(HttpServletRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    private void init() throws IOException {
        this.init(this.request);
        this.servletInputStream = this.request.getInputStream();
    }

    public void setupAsyncParse() throws IOException {
        this.init();
        if (!this.request.isAsyncSupported()) {
            throw new IllegalStateException("The servlet does not support async mode! Enable it or use a blocking parser.");
        }
        if (!this.request.isAsyncStarted()) {
            this.request.startAsync();
        }
        this.servletInputStream.setReadListener((ReadListener)this);
    }

    public void onDataAvailable() throws IOException {
        while (this.servletInputStream.isReady() && !this.servletInputStream.isFinished()) {
            this.parseCurrentItem();
        }
    }

    private boolean parseCurrentItem() throws IOException {
        int count = -1;
        if (!this.servletInputStream.isFinished()) {
            count = this.servletInputStream.read(this.dataBuffer.array());
        }
        if (count == -1) {
            if (!this.parseState.isComplete()) {
                throw new MultipartException("Stream ended unexpectedly!");
            }
        } else {
            this.checkRequestSize(count);
            this.dataBuffer.position(0);
            this.dataBuffer.limit(count);
            this.parseState.parse(this.dataBuffer);
        }
        return !this.parseState.isComplete();
    }

    public void onAllDataRead() throws IOException {
        while (this.parseCurrentItem()) {
        }
        try {
            if (this.requestCallback != null) {
                this.requestCallback.onRequestComplete(this.context);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void onError(Throwable throwable) {
        try {
            if (this.errorCallback != null) {
                this.errorCallback.onError(this.context, throwable);
            }
        }
        catch (ServletException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

