/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

class Base64Decoder {
    private static final byte[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;
    private int state;
    private int last;
    private static final int SKIP = 64768;
    private static final int MARK = 65024;
    private static final int DONE = 65280;
    private static final int ERROR = 983040;

    Base64Decoder() {
    }

    private static int nextByte(ByteBuffer buffer, int state, int last, boolean ignoreErrors) throws IOException {
        return Base64Decoder.nextByte(buffer.get() & 0xFF, state, last, ignoreErrors);
    }

    private static int nextByte(int charInt, int state, int last, boolean ignoreErrors) throws IOException {
        if (last == 65024) {
            if (charInt != 61) {
                throw new IOException("Expected padding character");
            }
            return 65280;
        }
        if (charInt == 61) {
            if (state == 2) {
                return 65024;
            }
            if (state == 3) {
                return 65280;
            }
            throw new IOException("Unexpected padding character");
        }
        if (charInt == 32 || charInt == 9 || charInt == 13 || charInt == 10) {
            return 64768;
        }
        if (charInt < 43 || charInt > 122) {
            if (ignoreErrors) {
                return 983040;
            }
            throw new IOException("Invalid base64 character encountered: " + charInt);
        }
        int byteInt = (DECODING_TABLE[charInt - 43] & 0xFF) - 1;
        if (byteInt < 0) {
            if (ignoreErrors) {
                return 983040;
            }
            throw new IOException("Invalid base64 character encountered: " + charInt);
        }
        return byteInt;
    }

    void decode(ByteBuffer source, ByteBuffer target) throws IOException {
        if (target == null) {
            throw new IllegalStateException();
        }
        int last = this.last;
        int state = this.state;
        int remaining = source.remaining();
        int targetRemaining = target.remaining();
        int byteInt = 0;
        while (remaining-- > 0 && targetRemaining > 0) {
            byteInt = Base64Decoder.nextByte(source, state, last, false);
            if (byteInt == 65024) {
                last = 65024;
                if (--remaining <= 0) break;
                byteInt = Base64Decoder.nextByte(source, state, last, false);
            }
            if (byteInt == 65280) {
                state = 0;
                last = 0;
                break;
            }
            if (byteInt == 64768) continue;
            if (state == 0) {
                last = byteInt << 2;
                ++state;
                if (remaining-- <= 0) break;
                byteInt = Base64Decoder.nextByte(source, state, last, false);
                if ((byteInt & 0xF000) != 0) {
                    source.position(source.position() - 1);
                    continue;
                }
            }
            if (state == 1) {
                target.put((byte)(last | byteInt >>> 4));
                last = (byteInt & 0xF) << 4;
                ++state;
                if (remaining-- <= 0 || --targetRemaining <= 0) break;
                byteInt = Base64Decoder.nextByte(source, state, last, false);
                if ((byteInt & 0xF000) != 0) {
                    source.position(source.position() - 1);
                    continue;
                }
            }
            if (state == 2) {
                target.put((byte)(last | byteInt >>> 2));
                last = (byteInt & 3) << 6;
                ++state;
                if (remaining-- <= 0 || --targetRemaining <= 0) break;
                byteInt = Base64Decoder.nextByte(source, state, last, false);
                if ((byteInt & 0xF000) != 0) {
                    source.position(source.position() - 1);
                    continue;
                }
            }
            if (state != 3) continue;
            target.put((byte)(last | byteInt));
            state = 0;
            last = 0;
            --targetRemaining;
        }
        if (remaining > 0) {
            Base64Decoder.drain(source, byteInt, state, last);
        }
        this.last = last;
        this.state = state;
    }

    private static void drain(ByteBuffer source, int byteInt, int state, int last) {
        while (byteInt != 65280 && source.remaining() > 0) {
            try {
                byteInt = Base64Decoder.nextByte(source, state, last, true);
            }
            catch (IOException e) {
                byteInt = 0;
            }
            if (byteInt == 65024) {
                last = 65024;
                continue;
            }
            if ((byteInt & 0xF000) != 0) continue;
            source.position(source.position() - 1);
            break;
        }
        if (byteInt == 65280) {
            while (source.remaining() > 0 && (byteInt = (int)source.get()) != 10) {
                if (byteInt == 32 || byteInt == 9 || byteInt == 13) continue;
                source.position(source.position() - 1);
                break;
            }
        }
    }

    static {
        DECODING_TABLE = new byte[80];
        ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < ENCODING_TABLE.length; ++i) {
            int offSet = (ENCODING_TABLE[i] & 0xFF) - 43;
            Base64Decoder.DECODING_TABLE[offSet] = (byte)(i + 1);
        }
    }
}

