/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.UploadContext;
import com.github.elopteryx.upload.errors.MultipartException;
import com.github.elopteryx.upload.internal.AbstractUploadParser;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;

public final class BlockingUploadParser
extends AbstractUploadParser {
    private final HttpServletRequest request;
    private InputStream inputStream;

    public BlockingUploadParser(HttpServletRequest request) {
        this.request = request;
    }

    private void init() throws IOException {
        this.init(this.request);
        this.inputStream = this.request.getInputStream();
    }

    public UploadContext doBlockingParse() throws IOException, ServletException {
        block3: {
            this.init();
            try {
                this.blockingRead();
                if (this.requestCallback != null) {
                    this.requestCallback.onRequestComplete(this.context);
                }
            }
            catch (Exception e) {
                if (this.errorCallback == null) break block3;
                this.errorCallback.onError(this.context, e);
            }
        }
        return this.context;
    }

    private void blockingRead() throws IOException {
        while (true) {
            int count;
            if ((count = this.inputStream.read(this.dataBuffer.array())) == -1) {
                if (this.parseState.isComplete()) break;
                throw new MultipartException("Stream ended unexpectedly!");
            }
            if (count <= 0) continue;
            this.checkRequestSize(count);
            this.dataBuffer.position(0);
            this.dataBuffer.limit(count);
            this.parseState.parse(this.dataBuffer);
        }
    }
}

