/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Headers {
    private static final String BOUNDARY = "boundary";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_TYPE = "Content-Type";
    private final Map<String, List<String>> headerNameToValueListMap = new LinkedHashMap<String, List<String>>();

    String getHeader(String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        List<String> headerValueList = this.headerNameToValueListMap.get(nameLower);
        return headerValueList == null ? null : headerValueList.get(0);
    }

    Collection<String> getHeaders(String name) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        return this.headerNameToValueListMap.getOrDefault(nameLower, Collections.emptyList());
    }

    Collection<String> getHeaderNames() {
        return this.headerNameToValueListMap.keySet();
    }

    void addHeader(String name, String value) {
        String nameLower = name.toLowerCase(Locale.ENGLISH);
        this.headerNameToValueListMap.computeIfAbsent(nameLower, key -> new ArrayList()).add(value);
    }

    public static String extractBoundaryFromHeader(String header) {
        int start;
        char character;
        int end;
        int pos = header.indexOf("boundary=");
        if (pos == -1) {
            return null;
        }
        for (end = start = pos + BOUNDARY.length() + 1; end < header.length() && (character = header.charAt(end)) != ' ' && character != '\t' && character != ';'; ++end) {
        }
        return header.substring(start, end);
    }

    public static String extractQuotedValueFromHeader(String header, String key) {
        int end;
        int keyPosition = 0;
        int pos = -1;
        boolean inQuotes = false;
        for (int i = 0; i < header.length() - 1; ++i) {
            char character = header.charAt(i);
            if (inQuotes) {
                if (character != '\"') continue;
                inQuotes = false;
                continue;
            }
            if (key.charAt(keyPosition) == character) {
                ++keyPosition;
            } else if (character == '\"') {
                keyPosition = 0;
                inQuotes = true;
            } else {
                keyPosition = 0;
            }
            if (keyPosition != key.length()) continue;
            if (header.charAt(i + 1) == '=') {
                pos = i + 2;
                break;
            }
            keyPosition = 0;
        }
        if (pos == -1) {
            return null;
        }
        int start = pos;
        if (header.charAt(start) == '\"') {
            char character;
            for (end = ++start; end < header.length() && (character = header.charAt(end)) != '\"'; ++end) {
            }
        } else {
            char character;
            for (end = start; end < header.length() && (character = header.charAt(end)) != ' ' && character != '\t'; ++end) {
            }
        }
        return header.substring(start, end);
    }
}

