/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.errors.MultipartException;
import com.github.elopteryx.upload.internal.Base64Decoder;
import com.github.elopteryx.upload.internal.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public final class MultipartParser {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    private static final String ERROR_MESSAGE = "Invalid multipart request!";

    private MultipartParser() {
    }

    public static ParseState beginParse(PartHandler handler, byte[] boundary, int bufferSize, Charset requestCharset) {
        byte[] boundaryToken = new byte[boundary.length + BOUNDARY_PREFIX.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, boundaryToken, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, boundaryToken, BOUNDARY_PREFIX.length, boundary.length);
        return new ParseState(handler, bufferSize, requestCharset, boundaryToken);
    }

    static class ParseState {
        private final PartHandler partHandler;
        private final Charset requestCharset;
        private final int bufferSize;
        private final byte[] boundary;
        private int state;
        private int subState = Integer.MAX_VALUE;
        private ByteArrayOutputStream currentString;
        private String currentHeaderName;
        private Headers headers;
        private Encoding encodingHandler;

        ParseState(PartHandler partHandler, int bufferSize, Charset requestCharset, byte[] boundary) {
            this.partHandler = partHandler;
            this.requestCharset = requestCharset;
            this.bufferSize = bufferSize;
            this.boundary = boundary;
        }

        void parse(ByteBuffer buffer) throws IOException {
            block7: while (buffer.hasRemaining()) {
                switch (this.state) {
                    case 0: {
                        this.preamble(buffer);
                        continue block7;
                    }
                    case 1: {
                        this.headerName(buffer);
                        continue block7;
                    }
                    case 2: {
                        this.headerValue(buffer);
                        continue block7;
                    }
                    case 3: {
                        this.entity(buffer);
                        continue block7;
                    }
                    case -1: {
                        return;
                    }
                }
                throw new IllegalStateException(String.valueOf(this.state));
            }
        }

        private void preamble(ByteBuffer buffer) {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (this.subState == Integer.MAX_VALUE) {
                        int n = this.subState = this.boundary[2] == b ? 2 : 0;
                    }
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        this.subState = 1;
                        continue;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b != 13) continue;
                    this.subState = -2;
                    continue;
                }
                if (this.subState != -2) continue;
                if (b == 10) {
                    this.subState = 0;
                    this.state = 1;
                    this.headers = new Headers();
                    return;
                }
                this.subState = -1;
            }
        }

        private void headerName(ByteBuffer buffer) throws MultipartException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b == 58) {
                    if (this.currentString == null || this.subState != 0) {
                        throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                    }
                    this.currentHeaderName = this.currentString.toString(this.requestCharset);
                    this.currentString.reset();
                    this.subState = 0;
                    this.state = 2;
                    return;
                }
                if (b == 13) {
                    if (this.currentString == null) {
                        this.subState = 1;
                        continue;
                    }
                    throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                }
                if (b == 10) {
                    if (this.currentString != null || this.subState != 1) {
                        throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                    }
                    this.state = 3;
                    this.subState = 0;
                    this.partHandler.beginPart(this.headers);
                    String encoding = this.headers.getHeader(MultipartParser.CONTENT_TRANSFER_ENCODING);
                    this.encodingHandler = encoding == null ? new IdentityEncoding() : ("base64".equalsIgnoreCase(encoding) ? new Base64Encoding(this.bufferSize) : ("quoted-printable".equalsIgnoreCase(encoding) ? new QuotedPrintableEncoding(this.bufferSize) : new IdentityEncoding()));
                    this.headers = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                }
                if (this.currentString == null) {
                    this.currentString = new ByteArrayOutputStream();
                }
                this.currentString.write(b);
            }
        }

        private void headerValue(ByteBuffer buffer) throws MultipartException {
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (b == 13) {
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.subState != 1) {
                        throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                    }
                    this.headers.addHeader(this.currentHeaderName.trim(), this.currentString.toString(this.requestCharset).trim());
                    this.state = 1;
                    this.subState = 0;
                    this.currentString = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MultipartException(MultipartParser.ERROR_MESSAGE);
                }
                this.currentString.write(b);
            }
        }

        private void entity(ByteBuffer buffer) throws IOException {
            int startingSubState = this.subState;
            int pos = buffer.position();
            while (buffer.hasRemaining()) {
                byte b = buffer.get();
                if (this.subState >= 0) {
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        startingSubState = 0;
                        ByteBuffer retBuffer = buffer.duplicate();
                        retBuffer.position(pos);
                        retBuffer.limit(Math.max(buffer.position() - this.boundary.length, 0));
                        this.encodingHandler.handle(this.partHandler, retBuffer);
                        this.partHandler.endPart();
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        if (startingSubState > 0) {
                            this.encodingHandler.handle(this.partHandler, ByteBuffer.wrap(this.boundary, 0, startingSubState));
                            startingSubState = 0;
                        }
                        this.subState = 1;
                        continue;
                    }
                    if (startingSubState > 0) {
                        this.encodingHandler.handle(this.partHandler, ByteBuffer.wrap(this.boundary, 0, startingSubState));
                        startingSubState = 0;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b == 13) {
                        this.subState = -2;
                        continue;
                    }
                    if (b != 45) continue;
                    this.subState = -3;
                    continue;
                }
                if (this.subState == -2) {
                    if (b == 10) {
                        this.subState = 0;
                        this.state = 1;
                        this.headers = new Headers();
                        return;
                    }
                    if (b == 45) {
                        this.subState = -3;
                        continue;
                    }
                    this.subState = -1;
                    continue;
                }
                if (this.subState != -3) continue;
                if (b == 45) {
                    this.state = -1;
                    return;
                }
                this.subState = -1;
            }
            ByteBuffer retBuffer = buffer.duplicate();
            retBuffer.position(pos);
            if (this.subState == 0) {
                this.encodingHandler.handle(this.partHandler, retBuffer);
            } else if (retBuffer.remaining() > this.subState && this.subState > 0) {
                retBuffer.limit(retBuffer.limit() - this.subState);
                this.encodingHandler.handle(this.partHandler, retBuffer);
            }
        }

        boolean isComplete() {
            return this.state == -1;
        }
    }

    static interface PartHandler {
        public void beginPart(Headers var1);

        public void data(ByteBuffer var1) throws IOException;

        public void endPart() throws IOException;
    }

    static class QuotedPrintableEncoding
    implements Encoding {
        boolean equalsSeen;
        byte firstCharacter;
        private final ByteBuffer buffer;

        QuotedPrintableEncoding(int size) {
            this.buffer = ByteBuffer.allocate(size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            boolean equalsSeen = this.equalsSeen;
            byte firstCharacter = this.firstCharacter;
            this.buffer.clear();
            try {
                while (rawData.hasRemaining()) {
                    byte readByte = rawData.get();
                    if (equalsSeen) {
                        if (firstCharacter == 0) {
                            if (readByte == 10 || readByte == 13) {
                                equalsSeen = false;
                                continue;
                            }
                            firstCharacter = readByte;
                            continue;
                        }
                        int result = Character.digit((char)firstCharacter, 16);
                        result <<= 4;
                        this.buffer.put((byte)(result += Character.digit((char)readByte, 16)));
                        equalsSeen = false;
                        firstCharacter = 0;
                        continue;
                    }
                    if (readByte == 61) {
                        equalsSeen = true;
                        continue;
                    }
                    this.buffer.put(readByte);
                    if (this.buffer.hasRemaining()) continue;
                    this.buffer.flip();
                    handler.data(this.buffer);
                    this.buffer.clear();
                }
                this.buffer.flip();
                handler.data(this.buffer);
            }
            finally {
                this.buffer.clear();
                this.equalsSeen = equalsSeen;
                this.firstCharacter = firstCharacter;
            }
        }
    }

    static class Base64Encoding
    implements Encoding {
        private final Base64Decoder decoder = new Base64Decoder();
        private final ByteBuffer buffer;

        Base64Encoding(int size) {
            this.buffer = ByteBuffer.allocate(size);
        }

        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            try {
                do {
                    this.buffer.clear();
                    this.decoder.decode(rawData, this.buffer);
                    this.buffer.flip();
                    handler.data(this.buffer);
                } while (rawData.hasRemaining());
            }
            finally {
                this.buffer.clear();
            }
        }
    }

    static class IdentityEncoding
    implements Encoding {
        IdentityEncoding() {
        }

        @Override
        public void handle(PartHandler handler, ByteBuffer rawData) throws IOException {
            handler.data(rawData);
            rawData.clear();
        }
    }

    static interface Encoding {
        public void handle(PartHandler var1, ByteBuffer var2) throws IOException;
    }
}

