/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.PartOutput;
import com.github.elopteryx.upload.PartStream;
import com.github.elopteryx.upload.internal.Headers;
import java.util.Collection;

public class PartStreamImpl
implements PartStream {
    private final String contentType;
    private final String fileName;
    private final String fieldName;
    private final boolean fileField;
    private final Headers headers;
    private long size;
    private boolean finished;
    private PartOutput output;

    public PartStreamImpl(String fileName, String fieldName, Headers headers) {
        this.fileName = fileName;
        this.fieldName = fieldName;
        this.contentType = headers.getHeader("Content-Type");
        this.fileField = fileName != null;
        this.headers = headers;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public long getKnownSize() {
        return this.size;
    }

    @Override
    public String getSubmittedFileName() {
        return this.checkFileName(this.fileName);
    }

    @Override
    public boolean isFile() {
        return this.fileField;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.getHeaderNames();
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return this.headers.getHeaders(name);
    }

    void setSize(long size) {
        this.size = size;
    }

    void markAsFinished() {
        this.finished = true;
    }

    public PartOutput getOutput() {
        return this.output;
    }

    void setOutput(PartOutput output) {
        this.output = output;
    }

    private String checkFileName(String fileName) {
        if (fileName != null && fileName.indexOf(0) != -1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fileName.length(); ++i) {
                char character = fileName.charAt(i);
                Object append = character == '\u0000' ? "\\0" : Character.valueOf(character);
                sb.append(append);
            }
            throw new IllegalArgumentException(fileName + " Invalid file name: " + sb);
        }
        return fileName;
    }
}

