/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.internal;

import com.github.elopteryx.upload.PartOutput;
import com.github.elopteryx.upload.PartStream;
import com.github.elopteryx.upload.UploadContext;
import com.github.elopteryx.upload.internal.PartStreamImpl;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UploadContextImpl
implements UploadContext {
    private final HttpServletRequest request;
    private final Object userObject;
    private PartStreamImpl currentPart;
    private PartOutput output;
    private final List<PartStream> partStreams = new ArrayList<PartStream>();
    private boolean buffering = true;
    private int partBytesRead;

    public UploadContextImpl(HttpServletRequest request, Object userObject) {
        this.request = request;
        this.userObject = userObject;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public <T> T getUserObject(Class<T> clazz) {
        return this.userObject == null ? null : (T)clazz.cast(this.userObject);
    }

    @Override
    public PartStreamImpl getCurrentPart() {
        return this.currentPart;
    }

    @Override
    public PartOutput getCurrentOutput() {
        return this.output;
    }

    @Override
    public List<PartStream> getPartStreams() {
        return Collections.unmodifiableList(this.partStreams);
    }

    void reset(PartStreamImpl newPart) {
        this.buffering = true;
        this.partBytesRead = 0;
        this.currentPart = newPart;
        this.partStreams.add(newPart);
        this.output = null;
    }

    void setOutput(PartOutput output) {
        this.output = output;
        this.currentPart.setOutput(output);
    }

    boolean isBuffering() {
        return this.buffering;
    }

    void finishBuffering() {
        this.buffering = false;
    }

    void updatePartBytesRead() {
        this.currentPart.setSize(this.partBytesRead);
    }

    int getPartBytesRead() {
        return this.partBytesRead;
    }

    int incrementAndGetPartBytesRead(int additional) {
        this.partBytesRead += additional;
        return this.partBytesRead;
    }
}

