/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private boolean open = true;

    public ByteBufferBackedInputStream(ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
        if (buffer.isDirect() || buffer.isReadOnly()) {
            throw new IllegalArgumentException("The buffer cannot be direct or read-only!");
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    @Override
    public int read() throws IOException {
        if (!this.open) {
            throw new IOException("The stream was closed!");
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("The stream was closed!");
        }
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(bytes, off, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }
}

