/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

class ByteBufferBackedOutputStream
extends OutputStream {
    private final ByteBuffer buffer;
    private boolean open = true;

    public ByteBufferBackedOutputStream(ByteBuffer buffer) {
        this.buffer = Objects.requireNonNull(buffer);
        if (buffer.isDirect() || buffer.isReadOnly()) {
            throw new IllegalArgumentException("The buffer cannot be direct or read-only!");
        }
    }

    @Override
    public void write(int byteToWrite) throws IOException {
        if (!this.open) {
            throw new IOException("The stream was closed!");
        }
        this.buffer.put((byte)byteToWrite);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (!this.open) {
            throw new IOException("The stream was closed!");
        }
        this.buffer.put(bytes, off, len);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }
}

