/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Objects;

class InputStreamBackedChannel
implements ReadableByteChannel {
    private boolean open = true;
    private final InputStream inputStream;

    public InputStreamBackedChannel(InputStream inputStream) {
        this.inputStream = Objects.requireNonNull(inputStream);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (dst.isDirect() || dst.isReadOnly()) {
            throw new IllegalArgumentException("The buffer cannot be direct or read-only!");
        }
        byte[] buf = dst.array();
        int offset = dst.position();
        int len = dst.remaining();
        int read = this.inputStream.read(buf, offset, len);
        dst.position(offset + read);
        return read;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.open = false;
    }
}

