/*
 * Decompiled with CFR 0.152.
 */
package com.github.elopteryx.upload.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class OutputStreamBackedChannel
implements WritableByteChannel {
    private boolean open = true;
    private final OutputStream outputStream;

    public OutputStreamBackedChannel(OutputStream outputStream) {
        this.outputStream = Objects.requireNonNull(outputStream);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (src.isDirect() || src.isReadOnly()) {
            throw new IllegalArgumentException("The buffer cannot be direct or read-only!");
        }
        byte[] buf = src.array();
        int offset = src.position();
        int len = src.remaining();
        this.outputStream.write(buf, offset, len);
        src.position(offset + len);
        return len;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
        this.open = false;
    }
}

