/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class FutureTaskBase<V>
implements RunnableFuture<V> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private volatile V result;
    private volatile Throwable cause;

    protected FutureTaskBase() {
    }

    @Override
    public final boolean isDone() {
        return this.completed.get();
    }

    private V getResult() throws ExecutionException {
        if (this.cause != null) {
            throw new ExecutionException(this.cause);
        }
        return this.result;
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result;
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        long timeoutInMillis = timeout == 0L ? Long.MAX_VALUE : unit.toMillis(timeout);
        long startTime = System.currentTimeMillis();
        long waitTime = timeoutInMillis;
        if (this.completed.get()) {
            return this.getResult();
        }
        if (waitTime <= 0L) {
            throw new TimeoutException();
        }
        do {
            this.latch.await(waitTime, TimeUnit.MILLISECONDS);
            if (!this.completed.get()) continue;
            return this.getResult();
        } while ((waitTime = timeoutInMillis - (System.currentTimeMillis() - startTime)) > 0L);
        throw new TimeoutException();
    }

    protected boolean set(V v) {
        if (!this.completed.get() && this.completed.compareAndSet(false, true)) {
            this.result = v;
            this.latch.countDown();
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable cause) {
        if (this.completed.compareAndSet(false, true)) {
            this.cause = cause;
            this.latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

