/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.concurrent;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;

public final class WeightThrottle {
    private final IntSet weightKeys = new IntArraySet();
    private final Int2IntMap weightMap = new Int2IntOpenHashMap();
    private final Int2IntMap remainingWeightMap = new Int2IntOpenHashMap();

    public WeightThrottle(Int2IntMap weightMap) throws IllegalArgumentException {
        this.weightKeys.addAll(weightMap.keySet());
        this.weightMap.putAll(weightMap);
        this.resetRemainingWeights();
    }

    private void resetRemainingWeights() throws IllegalArgumentException {
        IntIterator intIterator = this.weightKeys.iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            this.remainingWeightMap.put(key, this.weightMap.get(key));
        }
    }

    private void ensureRemainingWeights() {
        IntIterator intIterator = this.weightKeys.iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            if (this.remainingWeightMap.get(key) <= 0) continue;
            return;
        }
        this.resetRemainingWeights();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean tryAcquire(int key) {
        Int2IntMap int2IntMap = this.remainingWeightMap;
        synchronized (int2IntMap) {
            this.ensureRemainingWeights();
            int remainingWeight = this.remainingWeightMap.get(key);
            if (remainingWeight > 0) {
                this.remainingWeightMap.put(key, remainingWeight - 1);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int tryAcquire(int key, int times) {
        if (times == 0) {
            return 0;
        }
        Int2IntMap int2IntMap = this.remainingWeightMap;
        synchronized (int2IntMap) {
            this.ensureRemainingWeights();
            int remainingWeight = this.remainingWeightMap.get(key);
            if (times > remainingWeight) {
                this.remainingWeightMap.put(key, 0);
                return remainingWeight;
            }
            this.remainingWeightMap.put(key, remainingWeight - times);
            return times;
        }
    }
}

