/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.net;

import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.exception.OmgLookAtMyConsoleException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public interface NetUtil {
    public static InetAddress getHostAddr() throws OmgLookAtMyConsoleException, OmgDoesNotPerformException {
        Enumeration<NetworkInterface> netIfaces;
        InetAddress addr = null;
        try {
            netIfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new OmgLookAtMyConsoleException(e);
        }
        while (netIfaces.hasMoreElements()) {
            NetworkInterface nextNetIface = netIfaces.nextElement();
            try {
                if (nextNetIface.isLoopback() || !nextNetIface.isUp()) continue;
                Enumeration<InetAddress> addrs = nextNetIface.getInetAddresses();
                while (addrs.hasMoreElements() && !Inet4Address.class.isInstance(addr = addrs.nextElement())) {
                }
            }
            catch (SocketException e) {
                throw new OmgLookAtMyConsoleException(e);
            }
        }
        if (addr == null) {
            addr = InetAddress.getLoopbackAddress();
        }
        if (addr == null) {
            throw new OmgDoesNotPerformException("");
        }
        return addr;
    }

    public static String getHostAddrString() throws OmgDoesNotPerformException, OmgLookAtMyConsoleException {
        return NetUtil.getHostAddr().getHostAddress();
    }

    public static long getHostAddrCode() throws OmgDoesNotPerformException, OmgLookAtMyConsoleException {
        return NetUtil.getHostAddrString().hashCode();
    }
}

