/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.net.ssl;

import com.emc.mongoose.api.common.exception.Fireball;
import com.emc.mongoose.api.common.exception.OmgDoesNotPerformException;
import com.emc.mongoose.api.common.net.ssl.X509TrustAllManager;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public final class SslContext {
    public static volatile SSLContext INSTANCE;

    private SslContext() {
    }

    private static SSLContext getInstance() throws OmgDoesNotPerformException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{X509TrustAllManager.INSTANCE}, new SecureRandom());
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new OmgDoesNotPerformException(e);
        }
    }

    static {
        try {
            INSTANCE = SslContext.getInstance();
        }
        catch (Fireball e) {
            e.printStackTrace(System.err);
        }
    }
}

