/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.RangeDefinedLongSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import java.text.Format;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.FastDateFormat;

public class RangeDefinedDateFormattingSupplier
extends RangeDefinedLongSupplier
implements RangeDefinedSupplier<Date> {
    private Format format;
    private static ThreadLocal<Date> DATE = new ThreadLocal<Date>(){

        @Override
        protected final Date initialValue() {
            return new Date();
        }
    };

    public RangeDefinedDateFormattingSupplier(long seed, Date startDate, Date endDate, String formatStr) {
        super(seed, startDate.getTime(), endDate.getTime());
        this.format = formatStr == null || formatStr.isEmpty() ? null : FastDateFormat.getInstance((String)formatStr);
    }

    @Override
    public final String get() {
        Date date = DATE.get();
        date.setTime(this.getAsLong());
        return this.format == null ? date.toString() : this.format.format(date);
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        long[] numbers = new long[limit];
        int n = super.get(numbers, limit);
        Date date = DATE.get();
        if (this.format == null) {
            for (int i = 0; i < n; ++i) {
                date.setTime(numbers[i]);
                buffer.add(date.toString());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                date.setTime(numbers[i]);
                buffer.add(this.format.format(date));
            }
        }
        return n;
    }

    @Override
    public final Date value() {
        return new Date(this.getAsLong());
    }
}

