/*
 * Decompiled with CFR 0.152.
 */
package com.emc.mongoose.api.common.supply;

import com.emc.mongoose.api.common.supply.RangeDefinedDoubleSupplier;
import com.emc.mongoose.api.common.supply.RangeDefinedSupplier;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public final class RangeDefinedDoubleFormattingSupplier
extends RangeDefinedDoubleSupplier
implements RangeDefinedSupplier<Double> {
    private final NumberFormat format;

    public RangeDefinedDoubleFormattingSupplier(long seed, double min, double max, String formatStr) {
        super(seed, min, max);
        this.format = formatStr == null || formatStr.isEmpty() ? null : new DecimalFormat(formatStr);
    }

    @Override
    public final String get() {
        return this.format == null ? Double.toString(this.getAsDouble()) : this.format.format(this.getAsDouble());
    }

    @Override
    public final int get(List<String> buffer, int limit) {
        double[] numbers = new double[limit];
        int n = super.get(numbers, limit);
        if (this.format == null) {
            for (int i = 0; i < n; ++i) {
                buffer.add(Double.toString(numbers[i]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                buffer.add(this.format.format(numbers[i]));
            }
        }
        return n;
    }

    @Override
    public final Double value() {
        return this.getAsDouble();
    }

    @Override
    public final void close() throws IOException {
        super.close();
    }
}

